set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9796997';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '3',
      '0',
      '1',
      '3',
      '2',
      '0',
      '3',
      '2',
      '1',
      '0',
      '4',
      '2',
      '3',
      '0',
      '1',
      '3',
      '1',
      '2',
      NULL,
      NULL,
      '3',
      '3',
      '',
      '1',
      '',
      NULL,
      '0',
      '4',
      '0',
      NULL,
      '',
      '',
      '2',
      NULL,
      '1',
      '0',
      NULL,
      '2',
      '2',
      NULL,
      '0',
      '2',
      '3',
      '411',
      '11214442',
      NULL,
      NULL,
      '1103344',
      NULL,
      1.132613,
      2,
      NULL,
      '213003',
      4,
      ' 8- 6-1987',
      ' 3-17-1986',
      13.534158,
      11,
      29.666242,
      4.615848,
      27.101354,
      28.867461,
      NULL,
      NULL,
      19,
      8,
      NULL,
      0,
      19.601929,
      NULL,
      17.907973,
      8.039204,
      17,
      2.867961,
      NULL,
      15.580939,
      1,
      16,
      13.431353,
      NULL,
      1.587071,
      70,
      108,
      19,
      45,
      100.130059,
      95,
      NULL,
      38.062902,
      NULL,
      39.750643,
      NULL,
      10.446184,
      142.226278,
      ' 2- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      7,
      2.450811,
      6.438788,
      3,
      '11- 5-2000',
      0,
      1.490388,
      38.743371,
      1,
      0.318014,
      46.954580,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      NULL,
      ' 5-24-1980',
      NULL,
      41.024683,
      21.611057,
      103,
      49,
      NULL,
      NULL,
      NULL,
      54.611677,
      1,
      NULL,
      93,
      ' 5- 3-1999',
      5,
      37.501337,
      15,
      NULL,
      98,
      36,
      NULL,
      ' 3-28-2001',
      20,
      3.035413,
      ' 2-19-1977',
      7.670397,
      NULL,
      NULL,
      1,
      NULL,
      10.333589,
      0.276259,
      6,
      0,
      12.089388,
      12.705644,
      1,
      2.267650,
      1,
      2.781656,
      1.103440,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      10,
      ' 6-22-1990',
      NULL,
      NULL,
      NULL,
      17,
      ' 7- 4-1984',
      13.272776,
      ' 0- 2-1995',
      4.199108,
      17.722031,
      ' 9-23-2003',
      NULL,
      65.108929,
      ' 5-21-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      21,
      ' 5- 2-1977',
      64.999002,
      6.564255,
      15,
      ' 7- 5-1985',
      1.347301,
      NULL,
      NULL,
      15.877623,
      8,
      18,
      20,
      ' 4- 8-1999',
      73.361873,
      1,
      NULL,
      ' 7- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


