set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7504246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3143',
      '01131303',
      NULL,
      '22104321',
      '12421310',
      '24214401',
      NULL,
      '02241414',
      '20403211',
      '11240223',
      '30402101',
      NULL,
      NULL,
      NULL,
      '04410430',
      '03041424',
      '24001034',
      '22301413',
      '31221024',
      '40140412',
      '43433002',
      '34014440',
      '13223011',
      '11131141',
      '44004032',
      '12224013',
      NULL,
      NULL,
      '22313414',
      '12340144',
      '13104111',
      NULL,
      '44410421',
      '43434313',
      NULL,
      '41420210',
      '33141314',
      '01042214',
      NULL,
      NULL,
      '24402230',
      NULL,
      '20240132',
      '14034244',
      NULL,
      '341',
      '11',
      NULL,
      NULL,
      '4042003',
      1.560230,
      0.586508,
      3,
      NULL,
      '030224',
      5,
      '10- 2-1979',
      ' 2-19-2000',
      NULL,
      NULL,
      21,
      1.044606,
      3,
      3,
      3,
      15,
      17.070938,
      8.166895,
      38,
      15,
      28.351941,
      7.216772,
      29.482287,
      NULL,
      NULL,
      14,
      12.196042,
      5.529411,
      NULL,
      1,
      17.715083,
      11,
      0,
      59.530919,
      45,
      58,
      43,
      2.965453,
      NULL,
      '10-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.780164,
      2,
      3.260588,
      3.585270,
      6.363035,
      5,
      2.916403,
      NULL,
      NULL,
      1,
      5.829532,
      NULL,
      0.476592,
      8,
      0,
      0,
      NULL,
      0,
      1.521341,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1991',
      50,
      3.354376,
      14.398776,
      14,
      24.701874,
      7,
      ' 5- 6-1986',
      NULL,
      0.729258,
      6,
      NULL,
      9,
      43.263102,
      1,
      4.940313,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1981',
      63.579210,
      64,
      NULL,
      85,
      31,
      67.447931,
      NULL,
      65.228859,
      NULL,
      NULL,
      56,
      100,
      '10- 5-1996',
      NULL,
      NULL,
      NULL,
      21,
      77.746965,
      160.208786,
      10,
      '11- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      ' 1- 1-1998',
      11.667633,
      NULL,
      1.601449,
      2.002905,
      '11-24-1978',
      NULL,
      NULL,
      NULL,
      0,
      0.125827,
      ' 7- 0-2001',
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      41,
      20,
      5,
      '10- 8-1991',
      3.574354,
      420,
      ' 2-12-1984',
      9,
      27.358851,
      12,
      60,
      ' 1-27-1998',
      NULL,
      0.489247,
      NULL,
      ' 3-18-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


