set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '2',
      '1',
      '3',
      NULL,
      '1',
      NULL,
      '4',
      '4',
      '3',
      '4',
      '2',
      '4',
      '0',
      '1',
      '3',
      '4',
      '3',
      '1',
      '1',
      '1',
      '2',
      '3',
      '',
      NULL,
      '',
      '1',
      '1',
      NULL,
      '0',
      '1',
      '',
      '',
      '4',
      '4',
      '4',
      '0',
      '4',
      NULL,
      NULL,
      '0',
      '4',
      '4',
      '2',
      NULL,
      '42001333',
      62.252979,
      37,
      '4212210',
      1.049700,
      0,
      1,
      1,
      '241014',
      3.194886,
      ' 4-17-1981',
      ' 9-17-1978',
      NULL,
      184,
      19.234083,
      NULL,
      NULL,
      28.210400,
      106,
      17,
      4.209222,
      NULL,
      39.916437,
      NULL,
      NULL,
      2.682676,
      30,
      6.336621,
      20,
      14,
      96.755542,
      20,
      19.927080,
      31.778168,
      20,
      12.652189,
      1,
      137.999863,
      NULL,
      129.180542,
      196,
      NULL,
      33.765412,
      NULL,
      35.053970,
      66,
      37,
      15,
      100.988105,
      NULL,
      ' 0-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      NULL,
      NULL,
      6.101785,
      8,
      NULL,
      1.332239,
      NULL,
      8.943260,
      NULL,
      0,
      NULL,
      1,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      '11- 7-1984',
      113.794736,
      103.217618,
      84.083713,
      22,
      111.323134,
      23.122692,
      92,
      102,
      5.428106,
      50,
      44,
      47.560905,
      ' 1-15-1987',
      17,
      15.657856,
      21.890037,
      44,
      34,
      131.961355,
      12.420112,
      ' 2-15-1985',
      18.194614,
      28.928610,
      '11- 6-1994',
      NULL,
      2.894585,
      27,
      24.912349,
      NULL,
      NULL,
      0,
      1,
      1,
      118,
      1,
      NULL,
      18.487372,
      26,
      NULL,
      0.258231,
      0.035921,
      0,
      ' 1-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      80.567662,
      28.270753,
      ' 4-18-1989',
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      13.513629,
      ' 3- 7-1987',
      3,
      9.008735,
      ' 3- 1-1991',
      63.524428,
      102,
      ' 2-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.062805,
      ' 1- 1-1996',
      3,
      15,
      10.342910,
      ' 3-25-1985',
      NULL,
      NULL,
      ' 4- 0-1988',
      16,
      14,
      4.345615,
      22,
      ' 2-14-1999',
      31.795585,
      0,
      41.547024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


