set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '3',
      '0',
      NULL,
      '1',
      '0',
      '2',
      '3',
      '1',
      '1',
      '1',
      '4',
      '4',
      '4',
      '3',
      '4',
      '3',
      '1',
      '2',
      NULL,
      '',
      '4',
      '',
      '3',
      '4',
      NULL,
      '4',
      '2',
      '',
      '',
      '4',
      '2',
      '0',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '4',
      '3',
      '0',
      NULL,
      '01102100',
      64,
      44.401696,
      '0033031',
      3.656754,
      NULL,
      NULL,
      1,
      '001212',
      0,
      '10- 6-1978',
      '11-14-1991',
      75,
      101,
      39,
      3,
      NULL,
      4,
      65.293891,
      12,
      25,
      21.561841,
      NULL,
      21.204407,
      21,
      6,
      32.187257,
      20,
      15.380746,
      0,
      3.760857,
      1,
      53.554008,
      28.287778,
      104,
      9.099683,
      1,
      77,
      NULL,
      46.904831,
      NULL,
      70,
      152.128471,
      NULL,
      NULL,
      NULL,
      NULL,
      11.188995,
      92.536131,
      NULL,
      ' 8- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.160390,
      7,
      0,
      1,
      7.361701,
      7.094088,
      ' 8-12-1989',
      1.266796,
      NULL,
      133.330348,
      0.696973,
      NULL,
      NULL,
      0,
      0.548760,
      28.779389,
      NULL,
      NULL,
      NULL,
      ' 6-20-1992',
      NULL,
      NULL,
      NULL,
      98,
      97.036459,
      25,
      52.961221,
      28.660846,
      NULL,
      31.841070,
      107,
      25,
      ' 3-26-1976',
      34.982990,
      2,
      32,
      12,
      NULL,
      184.624994,
      NULL,
      ' 7-10-1992',
      8.630510,
      1,
      ' 3-25-2001',
      11,
      NULL,
      1,
      11,
      5,
      10.840868,
      0,
      22,
      1.790018,
      41.086864,
      NULL,
      0.388614,
      15,
      12,
      NULL,
      1.103555,
      1.462869,
      0,
      ' 1-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      236.016594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      ' 5- 8-1979',
      7.654900,
      ' 0- 9-1991',
      1,
      12.761884,
      ' 6- 3-1976',
      120.955829,
      79,
      ' 2-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '11-16-1975',
      19.024362,
      40,
      10,
      NULL,
      0,
      72.818141,
      ' 5-17-2003',
      10,
      NULL,
      15,
      31.725773,
      ' 0-16-1976',
      22.226111,
      1,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


