set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7413272';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0200',
      '01011111',
      NULL,
      '03034130',
      NULL,
      '43231330',
      '32134334',
      NULL,
      '10233212',
      '34443030',
      '34222003',
      NULL,
      NULL,
      '23232230',
      NULL,
      NULL,
      '43313020',
      '11301034',
      '22230004',
      '44040414',
      NULL,
      '40040000',
      '01004033',
      '11312330',
      '44303431',
      '42132400',
      '14034243',
      NULL,
      '11422014',
      '02424142',
      NULL,
      '20414114',
      '13444132',
      '43021024',
      NULL,
      '11204412',
      '00231020',
      NULL,
      '13323430',
      NULL,
      '02221340',
      '03432303',
      NULL,
      '44303201',
      '20313030',
      '',
      NULL,
      NULL,
      NULL,
      '0140133',
      0,
      1.630781,
      2,
      NULL,
      '231001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      7,
      31.789961,
      19,
      58,
      NULL,
      3,
      19,
      9,
      28.505820,
      7.941030,
      6,
      19,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.534703,
      NULL,
      0.255728,
      NULL,
      72,
      185.444760,
      NULL,
      NULL,
      161,
      85,
      NULL,
      4.537767,
      21.436336,
      21,
      8.489745,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.254653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.988449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.698874,
      125,
      29,
      78,
      74.802125,
      NULL,
      109.764046,
      NULL,
      NULL,
      108,
      NULL,
      48,
      NULL,
      28.641583,
      3,
      NULL,
      70,
      NULL,
      6.886572,
      7.092526,
      NULL,
      2,
      4.961299,
      NULL,
      12.490621,
      14.019783,
      25.261249,
      21,
      25.678642,
      10,
      NULL,
      18.985018,
      NULL,
      121.471211,
      1.424750,
      NULL,
      10.008494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      0.122349,
      12,
      NULL,
      NULL,
      184.709545,
      NULL,
      NULL,
      NULL,
      16.049658,
      40.496675,
      NULL,
      58,
      1,
      120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487800,
      78.928158,
      33.168321,
      51.318698,
      26,
      42.305661,
      NULL,
      76.369900,
      24.043148,
      3.479327,
      16,
      0,
      1.184481,
      NULL,
      1,
      0.185032,
      31,
      0.610525,
      NULL,
      136,
      1.439048,
      1.057928,
      64,
      NULL,
      31,
      67.202586,
      NULL,
      45.119474,
      NULL,
      0,
      NULL,
      1.309752,
      0,
      0,
      46.459443,
      92.737617,
      97.882616,
      2.562344,
      30.445186,
      NULL,
      NULL,
      NULL,
      32.673855,
      1.717410,
      NULL,
      1,
      23.870241,
      1.581825,
      NULL,
      NULL,
      29.321252,
      0,
      3,
      31,
      20.858386,
      NULL,
      9.048354,
      10.657340,
      75,
      16,
      7.776727,
      NULL,
      4.877758,
      1,
      1.594139,
      3.112887,
      1.341673,
      0,
      1.708514,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


