set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4111',
      '01430334',
      '13231202',
      '20024400',
      '21340030',
      '03404411',
      '43111204',
      '30021022',
      '20021202',
      NULL,
      '30010434',
      '20242001',
      '42023110',
      '40234104',
      '31313130',
      '40321244',
      '41323440',
      NULL,
      '32130142',
      NULL,
      '22001112',
      '32341103',
      '02003102',
      '13120021',
      '20231044',
      '42213044',
      '32043320',
      '42111000',
      NULL,
      '40012103',
      '21404244',
      NULL,
      '03412420',
      '31042431',
      '34410400',
      '14042440',
      '30012324',
      '32100322',
      '10442433',
      '20204303',
      '44342204',
      '23443323',
      '11012330',
      NULL,
      '22421312',
      '441',
      '40',
      9,
      15,
      '2212421',
      0.896164,
      0.214725,
      1,
      NULL,
      '133044',
      2,
      ' 1-15-2003',
      NULL,
      34,
      33.433890,
      0,
      NULL,
      NULL,
      16.810434,
      24,
      NULL,
      6,
      9.641982,
      31,
      NULL,
      27,
      11.782685,
      3,
      4.360857,
      6,
      6,
      34,
      9.497531,
      41,
      NULL,
      16.970382,
      2,
      0.303778,
      69.423668,
      164,
      5.380524,
      25,
      62,
      52.798699,
      ' 8-21-1987',
      56,
      6.781767,
      15.515079,
      26.938707,
      175.927468,
      117.588766,
      ' 3-29-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      17,
      7.043202,
      28.974250,
      NULL,
      7,
      ' 8- 7-1995',
      0,
      0.500884,
      176.131483,
      NULL,
      NULL,
      83,
      0.357359,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      '10- 1-2001',
      31,
      60,
      27.698459,
      NULL,
      13.399135,
      NULL,
      88.936673,
      83,
      50.560496,
      27.616668,
      47.002943,
      57,
      ' 1- 8-1987',
      15,
      NULL,
      NULL,
      NULL,
      7,
      10.000416,
      NULL,
      ' 8-18-1992',
      NULL,
      5.384742,
      ' 3- 5-1987',
      6,
      1.607416,
      NULL,
      10.322287,
      2.692097,
      9,
      0,
      NULL,
      0.430590,
      25.220449,
      1,
      0.206960,
      8,
      18.770433,
      NULL,
      3.303801,
      7,
      7,
      ' 7-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      88,
      NULL,
      ' 8- 6-1984',
      NULL,
      NULL,
      NULL,
      6,
      ' 6-15-1980',
      6,
      ' 6- 5-1977',
      12.680075,
      NULL,
      ' 9-23-1993',
      69.519468,
      34.487739,
      ' 0-25-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      10,
      ' 8-11-1990',
      27.855249,
      NULL,
      NULL,
      NULL,
      1,
      36,
      ' 4-13-1992',
      9,
      103.399539,
      13,
      7.635862,
      ' 6-10-1979',
      61,
      1,
      11,
      ' 0- 7-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


