set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0222',
      '41130313',
      NULL,
      '14313140',
      '03113432',
      NULL,
      '02330001',
      NULL,
      '31441304',
      '02222110',
      '04240034',
      '10330040',
      NULL,
      '33112113',
      NULL,
      NULL,
      '32430324',
      '23302014',
      '33231300',
      '33412042',
      '03140341',
      '34343103',
      '14120201',
      NULL,
      '04034004',
      '14430004',
      '32304320',
      '21114440',
      '43103210',
      '01440041',
      '33133144',
      NULL,
      NULL,
      '23031111',
      '22143122',
      '10101013',
      '03301212',
      '41430314',
      '21311042',
      NULL,
      '33433013',
      '32011014',
      '13203010',
      '00040420',
      '00104311',
      NULL,
      '33',
      26,
      13.536935,
      '3131243',
      2,
      0,
      1,
      NULL,
      '200103',
      NULL,
      ' 9- 8-2001',
      ' 4-20-1996',
      69.424010,
      17.228957,
      31.239156,
      7,
      19,
      17.754286,
      4.347242,
      2,
      1.018879,
      0,
      33.759300,
      4.132577,
      NULL,
      21,
      1,
      NULL,
      5.122760,
      13.636041,
      1.041107,
      16.528840,
      22.184246,
      21,
      70,
      NULL,
      0.945598,
      32.990235,
      96,
      31,
      153,
      16.462051,
      NULL,
      ' 8- 4-1986',
      9.832979,
      37,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      NULL,
      5,
      4,
      3.502845,
      4.442236,
      ' 3- 0-2002',
      0.848137,
      1,
      8,
      2,
      NULL,
      62,
      NULL,
      1,
      75.716923,
      NULL,
      NULL,
      NULL,
      ' 4-29-1991',
      108,
      44,
      49,
      59,
      NULL,
      72,
      5,
      8.265125,
      48,
      65,
      88,
      41,
      ' 0- 0-1991',
      35.311915,
      NULL,
      25.341465,
      NULL,
      NULL,
      133,
      7,
      '11- 0-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99.177866,
      NULL,
      ' 0-19-1977',
      NULL,
      NULL,
      NULL,
      27.954407,
      ' 9- 6-2001',
      4,
      ' 2- 0-2001',
      12,
      NULL,
      '10-12-1997',
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      13,
      NULL,
      19.378057,
      NULL,
      10.991979,
      ' 3-13-1981',
      1,
      18.169514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


