set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9685662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4434',
      NULL,
      '03404400',
      '32342243',
      '44112131',
      '40200144',
      '00000110',
      '03133032',
      '32230101',
      '43222010',
      '11323324',
      '01243111',
      '31403121',
      NULL,
      '03343044',
      '21213422',
      '33210421',
      '20043231',
      '12122322',
      NULL,
      '22442311',
      '42303132',
      '10214040',
      '12401344',
      '00332314',
      '33041043',
      '00133022',
      '10421044',
      '43022232',
      '40324423',
      NULL,
      '20211441',
      NULL,
      '34124434',
      '40122013',
      '21230000',
      '33334234',
      '04323434',
      '30303321',
      '31120024',
      '32322110',
      '24214322',
      '00332201',
      '03224143',
      '23300102',
      '140',
      '14',
      10.065241,
      6.643735,
      '1440414',
      2.418106,
      0.832413,
      2,
      NULL,
      '220330',
      NULL,
      ' 5- 1-1993',
      ' 8-20-1991',
      68.171470,
      52,
      NULL,
      17,
      NULL,
      NULL,
      14,
      NULL,
      5.336138,
      0,
      2.362255,
      NULL,
      12,
      NULL,
      6,
      0.451712,
      13.599314,
      13.660060,
      56.679696,
      NULL,
      19.824191,
      9.193496,
      74,
      6,
      1.564928,
      46.079239,
      17.219919,
      51.991605,
      NULL,
      91.606813,
      32.607507,
      ' 3-26-1983',
      11.573531,
      49.416850,
      5,
      2.764608,
      114.730980,
      116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      21,
      NULL,
      '11-12-1996',
      NULL,
      1.256130,
      149.209901,
      0.898087,
      3,
      54.562958,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1990',
      102.151331,
      53,
      NULL,
      32.132822,
      76.843559,
      66,
      12,
      3.606610,
      NULL,
      59,
      53,
      15,
      ' 3-20-1982',
      13.283322,
      NULL,
      23,
      3,
      NULL,
      NULL,
      9,
      ' 6- 9-1978',
      9,
      2,
      ' 9- 2-1981',
      NULL,
      9,
      16.884536,
      3.871664,
      6,
      NULL,
      0.816230,
      11.633004,
      1,
      NULL,
      11,
      4,
      1,
      29,
      1,
      4.629801,
      0,
      1.078813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      ' 5-12-1976',
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      17,
      ' 3-19-1991',
      3,
      1,
      NULL,
      11,
      23,
      ' 7- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10,
      ' 4- 4-1986',
      NULL,
      NULL,
      10,
      ' 9-16-1976',
      0,
      50.147308,
      '10- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


