set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7712658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2400',
      '32402420',
      '01324122',
      '23334313',
      '32004222',
      '30002340',
      '12044321',
      '32012343',
      '00004443',
      NULL,
      '33002400',
      '44144433',
      NULL,
      NULL,
      '24024031',
      '30021413',
      '30023101',
      NULL,
      '22402444',
      '03341003',
      NULL,
      '10214122',
      '31400044',
      '44313434',
      '02342401',
      '34431224',
      '30434011',
      '32102410',
      '20101130',
      '13212222',
      '44333011',
      '11012004',
      NULL,
      '32140120',
      '14142341',
      NULL,
      '03023004',
      '42242312',
      '12113431',
      '40233024',
      '30434400',
      '01114213',
      '00034041',
      '30103143',
      '41142230',
      '200',
      '33',
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1991',
      51.970336,
      NULL,
      8.461848,
      23.192495,
      10,
      1.790051,
      55,
      NULL,
      4,
      NULL,
      NULL,
      8,
      43,
      19.201772,
      NULL,
      9,
      21,
      19.713813,
      21.661542,
      14,
      22,
      NULL,
      61.828074,
      1,
      1.339127,
      19.810136,
      125.645293,
      NULL,
      1.628318,
      168,
      49.510101,
      ' 1-12-1987',
      22.803284,
      39,
      25.946766,
      0,
      NULL,
      97.208484,
      ' 2-27-1997',
      1.177374,
      2.845129,
      0,
      3,
      1.384858,
      0.846428,
      0,
      3.361714,
      NULL,
      NULL,
      2,
      NULL,
      0.676245,
      2.115724,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.111554,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1992',
      25.218416,
      6,
      8.769951,
      3,
      4.488767,
      4,
      ' 4- 4-1974',
      1.101261,
      1.074877,
      25.434116,
      1.278108,
      NULL,
      3,
      2,
      NULL,
      71,
      0,
      NULL,
      2.125921,
      ' 1- 7-2003',
      74.984490,
      74.813864,
      26.479381,
      93,
      52.718097,
      5,
      66.800085,
      13,
      NULL,
      48.099880,
      83.971905,
      NULL,
      ' 8-18-2000',
      16,
      20.165453,
      3,
      69,
      NULL,
      82,
      5,
      NULL,
      27,
      NULL,
      NULL,
      5,
      9,
      11.549552,
      0.913505,
      3.722061,
      7.202604,
      1,
      23,
      1.901281,
      NULL,
      NULL,
      NULL,
      6,
      22.750808,
      5,
      1,
      1.723186,
      1,
      NULL,
      NULL,
      NULL,
      0.225645,
      NULL,
      15,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      ' 1-12-2001',
      NULL,
      ' 2- 4-1998',
      11,
      1.102900,
      ' 7-24-1986',
      NULL,
      NULL,
      NULL,
      1.056073,
      8,
      ' 6- 9-1981',
      NULL,
      17.671357,
      ' 6-18-1987',
      1,
      3,
      NULL,
      '11- 1-1998',
      64,
      1,
      NULL,
      ' 7-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


