set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0301',
      '14240324',
      '14231401',
      '13244040',
      '42143421',
      '40134204',
      NULL,
      '11312131',
      '24033001',
      '33001331',
      '40014104',
      '43122141',
      '20443143',
      '43012134',
      NULL,
      '00400112',
      NULL,
      '30240041',
      '00141213',
      '42143431',
      '32322414',
      NULL,
      NULL,
      '22340402',
      NULL,
      '03033404',
      '30241011',
      '21433123',
      '33333203',
      NULL,
      NULL,
      '02301223',
      '30200103',
      '43303303',
      NULL,
      '24042111',
      '23024304',
      '31303444',
      '32141014',
      NULL,
      '22110402',
      NULL,
      '41124333',
      '01324310',
      '44244424',
      '424',
      '11',
      NULL,
      NULL,
      '2102321',
      1,
      0.038342,
      3,
      NULL,
      NULL,
      NULL,
      ' 3- 1-2002',
      ' 3-19-1995',
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      77.717799,
      NULL,
      4.076500,
      8.938915,
      34.422708,
      1,
      31.674225,
      NULL,
      17,
      17,
      NULL,
      1,
      68.774345,
      16,
      54,
      5.275755,
      NULL,
      19,
      0,
      44,
      47.582842,
      NULL,
      17.611041,
      231,
      NULL,
      '11-15-1996',
      35.558714,
      47,
      37,
      26.921929,
      141,
      204,
      NULL,
      1.253746,
      1.823564,
      NULL,
      0,
      1,
      1,
      1.796402,
      0.021174,
      1.123269,
      0,
      3,
      1.261496,
      0,
      NULL,
      0,
      NULL,
      4.773793,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-10-2000',
      34,
      3,
      NULL,
      9,
      9,
      7,
      ' 3-21-1993',
      1,
      NULL,
      NULL,
      1.964117,
      4,
      114.696950,
      1.881750,
      3.276626,
      23,
      NULL,
      3.566584,
      116,
      '11-18-1984',
      23.549363,
      NULL,
      36,
      91.397508,
      28.526954,
      106,
      37,
      19.886637,
      61,
      5.964832,
      NULL,
      NULL,
      NULL,
      4.733575,
      20,
      12,
      3.661259,
      68,
      59,
      0.561731,
      ' 1-21-1986',
      17.904187,
      19,
      '11-19-1991',
      9.472034,
      17.236954,
      3.810718,
      18.066920,
      18.540970,
      NULL,
      1,
      NULL,
      1.673644,
      20,
      1,
      NULL,
      25,
      28.195291,
      1.503168,
      1.737515,
      NULL,
      1.663703,
      ' 8-21-1998',
      9,
      4,
      2.094317,
      ' 3-19-1998',
      211.312244,
      6,
      '11-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1989',
      NULL,
      ' 1-17-1999',
      9.944508,
      20,
      ' 9-24-1975',
      31,
      15,
      ' 3-16-1994',
      13.560755,
      9,
      ' 3- 0-1990',
      1,
      0.666669,
      ' 3-25-1992',
      NULL,
      0,
      14,
      ' 8- 8-1999',
      13,
      52,
      9.401690,
      ' 1- 9-1996',
      1.259247,
      109.668597,
      ' 8- 6-1989',
      11.267446,
      6.696878,
      NULL,
      2.415019,
      ' 2-16-1983',
      17.903819,
      1,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9);
commit;
end;
/


