set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3323',
      '00123134',
      '20030123',
      NULL,
      '31011123',
      '20340331',
      '10001340',
      NULL,
      NULL,
      '04440102',
      '01133420',
      '14444330',
      '20041410',
      NULL,
      '23142213',
      '02024424',
      '13320211',
      '12103240',
      '32211024',
      '04304204',
      '10001103',
      '23024302',
      '02134231',
      '00234143',
      '22324421',
      '10000130',
      '04331204',
      NULL,
      NULL,
      '24342012',
      '30320013',
      '24100223',
      '44443422',
      NULL,
      '44111420',
      '03344334',
      NULL,
      '31103221',
      '24231421',
      '31342344',
      '22022000',
      NULL,
      '00343121',
      '23330334',
      '41200402',
      '000',
      '32',
      NULL,
      NULL,
      '4040034',
      3,
      NULL,
      3,
      NULL,
      '120422',
      NULL,
      ' 6-29-1998',
      ' 9-25-1987',
      90.523270,
      NULL,
      41.643637,
      4.693313,
      22.883168,
      23.943214,
      NULL,
      24.562287,
      25,
      17.168944,
      31,
      NULL,
      45.807881,
      NULL,
      11.842323,
      NULL,
      21.769589,
      10,
      NULL,
      NULL,
      53,
      24.738033,
      114.005456,
      14,
      1.305534,
      113,
      26.414885,
      64.656501,
      162.692335,
      84,
      21,
      '10-18-1974',
      6.900037,
      35.638866,
      37,
      35.689113,
      NULL,
      NULL,
      ' 0-25-1992',
      3,
      NULL,
      0,
      3.352433,
      1.216529,
      1.595008,
      1,
      2.252448,
      0.732099,
      1.581179,
      1,
      NULL,
      NULL,
      3.817602,
      NULL,
      1,
      1.492846,
      0.965992,
      0,
      3.604113,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1984',
      26,
      6.890349,
      13.904081,
      6.655227,
      6.331023,
      8,
      ' 8- 7-2003',
      1,
      1.402024,
      NULL,
      NULL,
      3.839674,
      109,
      0,
      3,
      31.584831,
      NULL,
      NULL,
      NULL,
      ' 3-24-1999',
      70.952458,
      NULL,
      113.459506,
      88.772023,
      15.660034,
      112,
      NULL,
      75,
      8.656609,
      112.588820,
      83.492159,
      1,
      ' 2- 0-1978',
      24,
      NULL,
      13,
      21.833057,
      76,
      14.771214,
      5.396745,
      ' 9-29-1986',
      NULL,
      NULL,
      ' 1-12-1991',
      8,
      11,
      13,
      6.829504,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      0,
      2,
      25.382143,
      3,
      1.059594,
      1,
      0,
      0.676307,
      ' 9-11-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590945,
      ' 8- 7-1976',
      NULL,
      NULL,
      NULL,
      19.115598,
      ' 4-24-1985',
      NULL,
      ' 3-16-1993',
      13.977476,
      NULL,
      ' 5- 1-1987',
      NULL,
      108,
      '11-11-1974',
      13,
      3.293430,
      ' 1- 3-2001',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.697913,
      ' 2-11-1992',
      10.521374,
      NULL,
      2,
      ' 9-13-1975',
      1.116538,
      NULL,
      ' 8- 9-1988',
      7.004125,
      12.434957,
      NULL,
      31.675400,
      NULL,
      51,
      1.831800,
      74.165812,
      ' 7-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


