set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202',
      '33421232',
      '24302211',
      '40303033',
      NULL,
      NULL,
      NULL,
      '33011240',
      '11332144',
      '20122403',
      '04123404',
      '23042343',
      NULL,
      NULL,
      '14344414',
      '21030442',
      NULL,
      '01141023',
      '04440444',
      '21334014',
      '02113424',
      '23041233',
      NULL,
      '20413314',
      '42004214',
      '41032244',
      '14400401',
      '41012020',
      '42113411',
      NULL,
      '02240024',
      '03030031',
      '02104220',
      '14231214',
      '23333010',
      '04241410',
      '20202410',
      '03422312',
      '31443421',
      NULL,
      NULL,
      '00120204',
      '10444010',
      '23313412',
      '24403413',
      '101',
      '00',
      29,
      NULL,
      '2120213',
      2.381083,
      NULL,
      3,
      NULL,
      '213444',
      NULL,
      ' 8- 0-1985',
      '10-14-1979',
      NULL,
      79.405256,
      NULL,
      1,
      22.292468,
      21.446436,
      89,
      25.124347,
      NULL,
      2.483049,
      11,
      4,
      3.191244,
      1.488089,
      NULL,
      14.292375,
      NULL,
      NULL,
      16,
      5,
      12,
      22,
      24,
      7.481747,
      NULL,
      56.509660,
      NULL,
      NULL,
      0,
      172,
      NULL,
      '11-29-1999',
      48.790474,
      NULL,
      15,
      8.144676,
      202.997227,
      15.301584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102.168340,
      12.206244,
      8.592871,
      0,
      6,
      5.333516,
      ' 4-21-2002',
      1.645257,
      NULL,
      81.160827,
      1,
      0,
      104,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1978',
      65.448207,
      123,
      43,
      119.581944,
      NULL,
      52,
      114.252213,
      112,
      64.207093,
      32.421093,
      107,
      NULL,
      ' 9- 1-1988',
      24.870560,
      12,
      20.164752,
      20,
      23.666964,
      48,
      4.633253,
      ' 1-15-1995',
      18,
      24,
      '11- 5-1997',
      7,
      NULL,
      10.478197,
      11.403294,
      4.952309,
      NULL,
      NULL,
      NULL,
      1.828015,
      21,
      3,
      NULL,
      0.259050,
      20,
      1.316738,
      2,
      0.661179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-2002',
      NULL,
      NULL,
      NULL,
      18,
      ' 8-10-1981',
      15.907034,
      ' 3- 5-1985',
      NULL,
      9.263760,
      ' 8-16-1978',
      11,
      128.040610,
      ' 6-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '11-29-1985',
      NULL,
      NULL,
      9.466199,
      ' 9-25-1998',
      1.243330,
      29.545837,
      NULL,
      6.591560,
      7.288434,
      20.575507,
      19.682917,
      ' 1-14-1997',
      NULL,
      0.293066,
      30.557972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


