set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '0',
      '4',
      '4',
      '0',
      '3',
      '0',
      '3',
      '3',
      '4',
      '0',
      NULL,
      '4',
      '1',
      '4',
      '1',
      NULL,
      '1',
      '3',
      '4',
      '3',
      '2',
      '3',
      '',
      '2',
      '',
      '1',
      NULL,
      '3',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      '4',
      NULL,
      NULL,
      '4',
      '0',
      '0',
      '002',
      '30014111',
      18.349166,
      58.015139,
      '1421002',
      3,
      132.277385,
      1,
      NULL,
      '004133',
      4,
      '10-20-1977',
      '10- 2-1977',
      292,
      106,
      NULL,
      24,
      16.947938,
      6,
      28.127911,
      8,
      21,
      4,
      NULL,
      7,
      41,
      7,
      0.297023,
      NULL,
      11.052026,
      NULL,
      NULL,
      13,
      64,
      22,
      60,
      2.526106,
      1,
      103.536882,
      NULL,
      79.889499,
      NULL,
      93.833976,
      62,
      NULL,
      NULL,
      21.430708,
      22.240203,
      30,
      81,
      130,
      ' 9-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70.742340,
      NULL,
      NULL,
      12.314454,
      3,
      5,
      ' 9- 3-1999',
      1,
      NULL,
      116,
      NULL,
      NULL,
      NULL,
      2,
      1.011754,
      13,
      NULL,
      NULL,
      NULL,
      ' 4-27-1983',
      8,
      48.409339,
      101.433061,
      76.545412,
      94,
      NULL,
      37,
      NULL,
      79.371551,
      87.157454,
      28,
      67.955149,
      NULL,
      7.866771,
      5,
      13,
      29.613688,
      16.762176,
      40.868711,
      11.362517,
      '10-18-1982',
      25.858450,
      NULL,
      ' 6-19-1994',
      0,
      16,
      20.383995,
      11,
      20,
      6,
      0,
      1.773317,
      1.389282,
      NULL,
      1,
      0.490448,
      NULL,
      22,
      1.679302,
      2,
      8.195538,
      4.000049,
      ' 3- 9-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      183,
      0.529114,
      ' 3-20-1990',
      NULL,
      NULL,
      NULL,
      48,
      ' 2-22-1996',
      22.486745,
      NULL,
      5,
      NULL,
      ' 2- 8-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.382685,
      ' 2-13-1987',
      12,
      40,
      58,
      '10-27-1977',
      1,
      105,
      ' 5-21-1989',
      16.215373,
      81.603669,
      NULL,
      NULL,
      '11-22-1981',
      61,
      1.168384,
      NULL,
      ' 3-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


