set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '2',
      '2',
      '3',
      '0',
      '3',
      '1',
      '3',
      '2',
      NULL,
      '4',
      '4',
      '1',
      '0',
      '4',
      NULL,
      '3',
      '2',
      '2',
      NULL,
      '3',
      '0',
      NULL,
      '',
      '4',
      '',
      '1',
      '3',
      '2',
      '4',
      NULL,
      '',
      NULL,
      '1',
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      '2',
      NULL,
      '113',
      '14434203',
      83,
      NULL,
      '2231024',
      3.928888,
      90,
      NULL,
      0,
      '403134',
      2,
      NULL,
      NULL,
      148.430811,
      94,
      NULL,
      23,
      6,
      NULL,
      NULL,
      20.247585,
      6,
      17,
      NULL,
      NULL,
      45,
      10,
      18.217038,
      11,
      16.959444,
      7,
      NULL,
      33,
      22.515305,
      14.276112,
      82.031868,
      17.033507,
      1.956603,
      72.532454,
      205,
      NULL,
      139.071374,
      136.885016,
      0.095243,
      NULL,
      10,
      NULL,
      26,
      37.102627,
      177,
      74,
      ' 0- 3-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      2.678330,
      11.076259,
      0,
      3,
      '10- 7-1975',
      1,
      1,
      80.030951,
      3,
      4.501430,
      107,
      0,
      2.928451,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1997',
      32.151289,
      42,
      15,
      7.405483,
      24.610346,
      30,
      29,
      67.255770,
      72.100716,
      40,
      NULL,
      NULL,
      ' 4-13-1994',
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      73,
      4.212949,
      NULL,
      38.354522,
      31.837171,
      ' 1- 0-2000',
      NULL,
      24,
      0,
      3.014452,
      30,
      0.897954,
      2.627078,
      NULL,
      0,
      NULL,
      1.784935,
      1.298639,
      23,
      18,
      NULL,
      3,
      0,
      3.149791,
      ' 4-11-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      153,
      NULL,
      ' 5-25-1994',
      NULL,
      NULL,
      NULL,
      39.562422,
      ' 4-12-1979',
      NULL,
      ' 5- 2-1994',
      8,
      4.833859,
      '10-19-1982',
      NULL,
      63,
      '11-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      19,
      ' 1-17-1974',
      55,
      3,
      64.686380,
      NULL,
      1,
      44,
      NULL,
      16,
      17.624054,
      21,
      NULL,
      '10- 7-1995',
      9,
      0.603275,
      26,
      ' 1- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


