set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04144230',
      '10403113',
      '12214432',
      NULL,
      NULL,
      '03142444',
      '33132013',
      '14332011',
      '32221214',
      '11231432',
      '44233141',
      '41041242',
      '10301002',
      '13240242',
      '42102233',
      '43313212',
      NULL,
      NULL,
      '32304030',
      '23022403',
      '10211102',
      '40242023',
      '21123223',
      '33033322',
      '03022424',
      '00243210',
      '43441222',
      NULL,
      '23400133',
      '00303312',
      NULL,
      '12311434',
      NULL,
      NULL,
      '04302443',
      '32001244',
      '32042323',
      '00113313',
      NULL,
      '00400102',
      '24130141',
      '22130042',
      '31212133',
      '32132303',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2.525441,
      13,
      1,
      NULL,
      '103412',
      NULL,
      NULL,
      NULL,
      9.430597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      46,
      26.879326,
      30,
      203,
      NULL,
      ' 1- 4-1986',
      2.252829,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.653228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1978',
      67.074943,
      116.586247,
      3,
      85.417656,
      NULL,
      85.907764,
      71.928872,
      75,
      2,
      85.817510,
      NULL,
      5.675289,
      ' 3-23-1999',
      NULL,
      9,
      11.686796,
      29,
      NULL,
      NULL,
      9.860036,
      ' 5- 0-1984',
      6,
      5.861102,
      ' 9- 4-1987',
      NULL,
      NULL,
      17.258846,
      5,
      9.574724,
      9,
      NULL,
      0,
      NULL,
      91,
      NULL,
      5.017858,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155263,
      NULL,
      ' 2- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      1.446398,
      0.463615,
      89,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      90.200811,
      0,
      1,
      60.088791,
      0,
      4,
      30,
      1.104272,
      0.209294,
      326.277670,
      113.097480,
      NULL,
      NULL,
      1,
      89.101991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.455121,
      NULL,
      NULL,
      NULL,
      41,
      1.043494,
      NULL,
      12.896100,
      1,
      1.197537,
      0,
      8,
      1,
      88,
      1.354354,
      17.618709,
      1.327957,
      1.479896,
      NULL,
      NULL,
      NULL,
      32.559374,
      9,
      NULL,
      NULL,
      NULL,
      2.604624,
      1.067172,
      NULL,
      2.865507,
      1,
      1,
      1,
      0.193091,
      84.513343,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-12-1994',
      NULL,
      '11- 1-1994',
      NULL);
commit;
end;
/


