set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4023',
      '13234000',
      '40103413',
      '42340042',
      NULL,
      '13331140',
      NULL,
      NULL,
      '24321342',
      '12103021',
      '44342411',
      '01341030',
      '14340004',
      '03204011',
      '43103230',
      '12324014',
      '30341412',
      '12142002',
      '14144321',
      '32143121',
      '23304034',
      '14303112',
      '32311303',
      '30142320',
      NULL,
      '34342312',
      '13013431',
      '24002013',
      NULL,
      NULL,
      '34313444',
      '41203321',
      NULL,
      '04440103',
      '13334131',
      '32032244',
      '12441101',
      '02102441',
      '00034130',
      '03433413',
      '02140144',
      NULL,
      NULL,
      '33023122',
      '22202441',
      '142',
      '41',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      '232322',
      1.078305,
      ' 2-22-1989',
      ' 5-16-1985',
      27.490342,
      NULL,
      7,
      17.527681,
      20,
      11,
      106.172063,
      11.983239,
      9,
      3.537684,
      59,
      10,
      5.050733,
      NULL,
      20.955846,
      22,
      NULL,
      8.958089,
      25.717238,
      16.824578,
      14,
      20,
      22,
      4.820118,
      NULL,
      110,
      53,
      1.789024,
      NULL,
      NULL,
      104.511361,
      '10-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.601320,
      1.052706,
      1.566014,
      NULL,
      0,
      0.317101,
      1,
      0.163594,
      0,
      0.332135,
      0.263358,
      NULL,
      1,
      0.436313,
      0,
      1.050828,
      NULL,
      1.006266,
      0.380324,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-27-1994',
      75.236636,
      18.126927,
      0.915026,
      NULL,
      0,
      1.552363,
      NULL,
      0.497787,
      1.894666,
      NULL,
      0.948400,
      NULL,
      89.095792,
      0.512420,
      0,
      43,
      1.219616,
      1.708091,
      92.589527,
      ' 9-23-1982',
      103,
      35.226204,
      NULL,
      16.459171,
      54.001370,
      112,
      52.078330,
      42,
      70.524062,
      76,
      112,
      87,
      '10- 2-1990',
      NULL,
      2.836510,
      16,
      41.254320,
      25,
      24,
      7,
      ' 1-14-1984',
      26.896242,
      7.408658,
      ' 5-29-1977',
      NULL,
      0,
      5.411788,
      3.387715,
      3,
      NULL,
      NULL,
      11.420106,
      NULL,
      43,
      0.805199,
      3,
      1.213812,
      12,
      0.176954,
      0,
      2,
      0.326111,
      ' 0-20-1999',
      0,
      1,
      2,
      ' 8-24-2000',
      NULL,
      2,
      ' 0-15-2003',
      NULL,
      NULL,
      NULL,
      20.923401,
      ' 6-23-1995',
      47.414675,
      NULL,
      2.269428,
      8,
      NULL,
      NULL,
      NULL,
      ' 6-10-1996',
      5,
      5,
      NULL,
      8,
      NULL,
      ' 8-18-1995',
      2,
      0,
      23.705203,
      ' 3-25-1980',
      52,
      NULL,
      NULL,
      ' 4- 6-1977',
      1,
      12,
      ' 9-13-1988',
      18.146290,
      9.438318,
      20,
      NULL,
      ' 2-10-1989',
      NULL,
      1.774315,
      119,
      ' 9-15-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.890013);
commit;
end;
/


