set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2342',
      NULL,
      NULL,
      '12030243',
      NULL,
      NULL,
      NULL,
      '40232302',
      '43433433',
      '13000143',
      '30322233',
      '11001133',
      '43441233',
      '32042110',
      '23033001',
      '43133223',
      NULL,
      '20004433',
      NULL,
      '11344200',
      '01021044',
      NULL,
      '01143343',
      '23101222',
      '40030202',
      '24120112',
      NULL,
      '20311331',
      NULL,
      NULL,
      '02223113',
      '34044242',
      '13134300',
      '31003010',
      NULL,
      '34120132',
      NULL,
      '24312003',
      '00403012',
      '01134220',
      '23333033',
      NULL,
      '13024014',
      '13314343',
      '13312443',
      '311',
      '42',
      22.316299,
      9.143521,
      '0210211',
      0.464113,
      19.379614,
      2,
      NULL,
      '222241',
      2,
      NULL,
      '10- 7-1983',
      9,
      NULL,
      31,
      26,
      11.994336,
      NULL,
      34,
      NULL,
      2.101235,
      5.371802,
      NULL,
      13,
      NULL,
      25.657098,
      36.824943,
      NULL,
      20.027129,
      NULL,
      44,
      14,
      58.470581,
      24.184176,
      31.613037,
      15.752867,
      0.682632,
      104,
      55,
      112,
      116,
      247.161634,
      150.659189,
      NULL,
      37.849516,
      70.771107,
      31,
      34,
      40,
      184.372948,
      '10-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86.347370,
      19,
      10.325588,
      3,
      15,
      6,
      ' 7-26-2001',
      1.357774,
      1.201674,
      70,
      1.451127,
      1.382959,
      6,
      0,
      0,
      73.751701,
      NULL,
      NULL,
      NULL,
      ' 5-15-1997',
      100.146939,
      83,
      72.630241,
      59,
      64,
      78.213102,
      39,
      NULL,
      NULL,
      0,
      84,
      42.633035,
      ' 7- 4-1991',
      2,
      NULL,
      NULL,
      56.766267,
      0,
      58,
      NULL,
      ' 9-25-1991',
      4,
      NULL,
      ' 4-13-2001',
      11.885667,
      13,
      18,
      0,
      3,
      NULL,
      1,
      16,
      1,
      99.454331,
      1,
      6,
      17.415221,
      7,
      2.909090,
      0,
      NULL,
      NULL,
      ' 8- 7-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1980',
      NULL,
      NULL,
      NULL,
      53.583328,
      ' 6-26-1985',
      10,
      ' 7- 2-2003',
      9,
      NULL,
      NULL,
      110,
      97,
      ' 5-26-1993',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      ' 7- 5-2001',
      22,
      59,
      59.608408,
      '11-17-1988',
      1.152735,
      122,
      ' 5- 1-1995',
      7.522049,
      33.172929,
      9,
      11.016139,
      NULL,
      NULL,
      NULL,
      143,
      ' 0-15-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


