set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2444',
      '03102114',
      NULL,
      '31310304',
      '04343140',
      '40421303',
      '40244044',
      NULL,
      '14044120',
      '03011244',
      '23104213',
      '21223120',
      '14132022',
      NULL,
      '12014234',
      '44214243',
      '23231230',
      '31414102',
      '22204330',
      '11023421',
      '01022100',
      '41322141',
      NULL,
      '01332230',
      '03241021',
      '40333434',
      '43444400',
      '30102034',
      '13004314',
      '31321420',
      NULL,
      '11321013',
      '32030244',
      '12440042',
      '01124443',
      '33121003',
      '03003403',
      '24023043',
      '20103340',
      '43303404',
      '31312321',
      NULL,
      '43340424',
      '00203400',
      '34130202',
      NULL,
      '31',
      12,
      11,
      '3210433',
      0.417941,
      70,
      NULL,
      NULL,
      '330141',
      2,
      '10-22-1997',
      ' 0- 5-1983',
      49.943280,
      108.410337,
      23,
      13,
      15,
      19.820000,
      84,
      19,
      3.469949,
      30,
      7.821403,
      NULL,
      25.977934,
      3.770137,
      NULL,
      20,
      22,
      8.462753,
      18.100026,
      8,
      NULL,
      27.735703,
      42.336730,
      0.009217,
      NULL,
      130.557245,
      27.554220,
      39,
      231.504327,
      94,
      213,
      ' 2- 0-2002',
      21,
      61,
      7,
      1,
      196.362541,
      102.454385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72.034627,
      3.164171,
      4.740166,
      4.985030,
      0,
      9,
      NULL,
      1.743837,
      0.922167,
      140.515549,
      1,
      1.658263,
      97,
      1,
      1.541923,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1997',
      NULL,
      NULL,
      73.279526,
      32,
      14,
      15,
      49.880720,
      33.043009,
      12.691336,
      21.867300,
      89,
      76.088744,
      ' 5-14-1997',
      NULL,
      10,
      17.916118,
      64,
      NULL,
      1.791890,
      3.335862,
      ' 0- 0-2002',
      NULL,
      4.270348,
      ' 7-20-2003',
      6,
      20,
      23,
      19,
      14,
      3,
      2.981729,
      4,
      1,
      2,
      1.850994,
      1,
      13.892191,
      6,
      1,
      3,
      0,
      3.872332,
      ' 3- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.230533,
      ' 1- 6-1981',
      NULL,
      NULL,
      NULL,
      17,
      ' 2-11-1999',
      10,
      ' 4-24-1997',
      9,
      NULL,
      ' 4-25-1990',
      19,
      51,
      ' 7- 1-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.728147,
      ' 7-22-1994',
      25.923884,
      20,
      59.249726,
      ' 4-11-1993',
      1,
      121,
      ' 7- 8-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.480168,
      1,
      18.793080,
      ' 4-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


