set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '4',
      '2',
      '0',
      '4',
      '2',
      NULL,
      '1',
      '3',
      NULL,
      '3',
      '1',
      '0',
      '1',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '',
      '4',
      NULL,
      '0',
      NULL,
      '0',
      '2',
      '2',
      '',
      '',
      '0',
      '3',
      NULL,
      '4',
      '4',
      '4',
      '4',
      '2',
      '4',
      '4',
      '3',
      '133',
      NULL,
      47,
      69,
      '2132312',
      0,
      56,
      2,
      NULL,
      NULL,
      0.280755,
      ' 7- 5-1980',
      ' 1-21-1976',
      42,
      NULL,
      32,
      8.152936,
      13.341865,
      15.143595,
      110.534593,
      8.390813,
      0.041027,
      NULL,
      16.220148,
      17,
      21.246495,
      6.718726,
      14.874239,
      NULL,
      27.371830,
      NULL,
      11,
      26.854897,
      1.470360,
      15.070269,
      80.801902,
      3.881685,
      NULL,
      NULL,
      216,
      105.990080,
      144.046577,
      202,
      33.714779,
      ' 4- 1-1999',
      NULL,
      70.790640,
      35.110004,
      NULL,
      216.628991,
      NULL,
      ' 7-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      8,
      7,
      1.623624,
      NULL,
      1.834603,
      ' 7- 3-1989',
      2,
      0,
      116.869121,
      1.791900,
      1,
      80,
      0.060575,
      1.869082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.164444,
      75.958531,
      78.801340,
      65.054211,
      46,
      19,
      21.560186,
      103.731168,
      94.592272,
      1,
      87,
      '11-16-1979',
      19.108997,
      NULL,
      4.199950,
      22.862374,
      27,
      6,
      3.837229,
      ' 0-18-1987',
      27.651697,
      5,
      NULL,
      NULL,
      10,
      12.577545,
      7,
      8.624030,
      0,
      1.939180,
      12.840748,
      1,
      29,
      1.261694,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.624366,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      186,
      7,
      ' 4- 3-1989',
      NULL,
      NULL,
      NULL,
      31,
      ' 0- 1-1994',
      9,
      '11-14-1984',
      8,
      0,
      ' 2-23-1984',
      NULL,
      116,
      ' 9-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      ' 5-14-1984',
      15,
      NULL,
      40.178110,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      9.992940,
      16,
      47.119383,
      ' 0-20-2002',
      NULL,
      1.828634,
      236,
      ' 6- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


