set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7731473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      '1',
      '3',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '3',
      '2',
      '3',
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      '0',
      '',
      '1',
      '',
      '1',
      '0',
      '4',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      '0',
      '044',
      '32030331',
      29,
      65,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '403011',
      1.335020,
      ' 7- 5-1990',
      NULL,
      27,
      220.091165,
      46,
      1,
      11.511762,
      5.132746,
      NULL,
      19,
      32.307682,
      34,
      21.541371,
      13,
      4.271246,
      28,
      10,
      NULL,
      NULL,
      20.033543,
      12.461321,
      21,
      52.880089,
      29.512593,
      35.232922,
      NULL,
      1,
      67.142561,
      90,
      8.577978,
      208.568319,
      204,
      NULL,
      ' 3-14-1984',
      61.387930,
      NULL,
      6,
      18,
      NULL,
      20,
      ' 3-18-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.522982,
      0.224853,
      2,
      NULL,
      9.695223,
      2.290710,
      NULL,
      1,
      1.803368,
      NULL,
      0,
      1.451157,
      124.382459,
      1,
      0,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      114,
      101.098723,
      NULL,
      63.317747,
      72,
      100.971563,
      NULL,
      73.837138,
      46,
      41,
      33,
      103.371426,
      ' 2- 6-1990',
      3.506591,
      NULL,
      4,
      NULL,
      33.663470,
      9,
      NULL,
      ' 0-23-1985',
      22.961883,
      NULL,
      NULL,
      NULL,
      9,
      19.123021,
      NULL,
      NULL,
      9,
      NULL,
      16,
      0,
      55.780319,
      1,
      1,
      15,
      NULL,
      1,
      1,
      NULL,
      0.535721,
      ' 0-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-29-2001',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.896927,
      0.432746,
      ' 9-11-1980',
      NULL,
      2.672402,
      ' 3-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      9.750135,
      ' 4-12-2001',
      62,
      23,
      17.682110,
      ' 8- 6-1974',
      1.079154,
      NULL,
      NULL,
      11,
      24,
      15,
      66,
      NULL,
      59,
      1.119941,
      NULL,
      ' 9-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


