set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0302',
      '04411023',
      '04142322',
      '13310102',
      '14313400',
      NULL,
      '11343441',
      '44331134',
      '13232432',
      '44321223',
      '03413214',
      '34433200',
      '33013034',
      '41122334',
      '20200301',
      '12021403',
      NULL,
      '43423340',
      '14442040',
      NULL,
      '12143311',
      NULL,
      '42333242',
      '01244420',
      NULL,
      '00113113',
      NULL,
      '00123041',
      '32400202',
      '10014212',
      '32321304',
      '42041211',
      '14420343',
      '03304222',
      '42320301',
      '12414344',
      NULL,
      '10024301',
      '14221124',
      NULL,
      '13322204',
      '14242043',
      '43340424',
      '02130004',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1101214',
      0.190375,
      1.017488,
      2,
      NULL,
      NULL,
      3.446348,
      ' 6-22-1987',
      '10- 7-1994',
      34,
      NULL,
      24,
      17.056401,
      12,
      3,
      NULL,
      16.576120,
      NULL,
      10.551100,
      9.876393,
      13,
      32.803731,
      1.814756,
      10.833476,
      10,
      2,
      7.941181,
      45.611694,
      5.684163,
      NULL,
      6.127124,
      10.191635,
      2.686438,
      NULL,
      28.115389,
      20.047126,
      2,
      68.906781,
      112.820650,
      NULL,
      ' 5- 6-1998',
      NULL,
      10,
      29,
      0,
      83,
      187,
      ' 7-23-1974',
      NULL,
      0.392883,
      8.866946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887468,
      3.434420,
      NULL,
      1,
      1.260528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1985',
      NULL,
      NULL,
      89,
      35.799106,
      8,
      100,
      43,
      41,
      30.178710,
      70,
      75.789687,
      56.495233,
      ' 2-23-1989',
      14,
      11,
      6.354873,
      25.799561,
      56,
      21,
      2,
      ' 7-11-2002',
      5.940195,
      NULL,
      NULL,
      1.670798,
      8,
      2.760998,
      3,
      13.699225,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      1.969159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      16,
      5,
      ' 1-10-2002',
      1,
      43.712943,
      ' 0-19-1983',
      NULL,
      3.339170,
      7.863670,
      NULL,
      ' 5-26-1976',
      16,
      NULL,
      136.881910,
      ' 3-29-1984',
      NULL,
      NULL,
      NULL,
      53.271378,
      39.940424,
      0.975185,
      53,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.631536,
      0.384036,
      11.425763,
      0.616601,
      NULL,
      40.926733,
      NULL,
      NULL,
      NULL,
      3,
      1.434886,
      146.073744,
      1,
      NULL,
      NULL,
      19.918934,
      NULL,
      1.168247,
      NULL,
      46.809589,
      1.680174,
      0,
      NULL,
      0,
      1,
      0,
      0,
      66,
      7.458682,
      10.043961,
      11.661133,
      13.808748,
      0.106026,
      0,
      1.523500,
      1,
      NULL,
      0,
      23,
      1,
      76.140404,
      1,
      40,
      NULL,
      1.825851,
      NULL,
      7.769420,
      6,
      NULL,
      NULL,
      27.749203,
      20.355649,
      24.987386,
      0.501087,
      4,
      1.230640,
      7.593218,
      0,
      1,
      1.404218,
      3,
      88,
      NULL,
      ' 0- 7-1999',
      ' 3-21-1995',
      ' 0-14-1979',
      ' 5- 5-1980',
      ' 0- 3-2001',
      NULL,
      NULL);
commit;
end;
/


