set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2010',
      '32420042',
      '22032010',
      '23241423',
      '32244100',
      '21004322',
      '32420023',
      '40120004',
      '24221220',
      '42023102',
      NULL,
      '12242214',
      NULL,
      '34241424',
      '34011343',
      '32204102',
      NULL,
      '14414103',
      '01140443',
      NULL,
      '01101334',
      NULL,
      '41200113',
      '30034434',
      NULL,
      '31402324',
      '34120144',
      '01011213',
      '41203214',
      '22314134',
      '30214104',
      NULL,
      '24030404',
      '10431004',
      '30214342',
      '11332340',
      NULL,
      '44102032',
      '12001242',
      '43140324',
      '42244434',
      '33144110',
      NULL,
      '10230412',
      '02023032',
      NULL,
      '01',
      NULL,
      NULL,
      '1202203',
      2,
      3,
      3,
      NULL,
      '240443',
      2,
      '11- 4-1990',
      ' 5-29-1988',
      32.822615,
      NULL,
      37,
      11.285953,
      15.459934,
      11.322636,
      63,
      12,
      20.096323,
      NULL,
      4.235507,
      2,
      15,
      5.059059,
      18.480105,
      NULL,
      NULL,
      14.746408,
      13.188864,
      10.534934,
      28,
      10.148692,
      88.894832,
      4.906515,
      2.241030,
      NULL,
      73,
      45,
      NULL,
      59,
      38,
      ' 2-20-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.725787,
      NULL,
      4,
      NULL,
      12.842943,
      0.134480,
      10.128732,
      1,
      0,
      13.707425,
      0,
      1,
      6,
      NULL,
      1,
      11,
      0,
      0,
      3.480784,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1982',
      96.174693,
      28.513161,
      NULL,
      8,
      NULL,
      NULL,
      ' 4-20-1983',
      1,
      1,
      48,
      0,
      0.499973,
      4.325541,
      0,
      1.948380,
      45,
      1.898070,
      NULL,
      63.894119,
      ' 0-21-1977',
      NULL,
      25,
      65,
      78.103174,
      12.183277,
      NULL,
      40,
      NULL,
      69,
      27,
      22,
      57,
      ' 6- 3-1975',
      NULL,
      21,
      6.924186,
      24.722689,
      29.109391,
      113,
      0,
      '10- 9-1988',
      NULL,
      3,
      NULL,
      13.412479,
      2.131409,
      5,
      15.648631,
      2.674490,
      8,
      4.055868,
      9,
      0,
      54,
      2.170507,
      12.623048,
      NULL,
      24,
      1,
      8.504417,
      NULL,
      1,
      '11-22-1987',
      5.520407,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      18,
      '10-13-1988',
      11.879033,
      9,
      ' 5-11-1988',
      65,
      15,
      ' 1-26-2002',
      1,
      5,
      '11- 6-1977',
      1.826861,
      9,
      ' 5-18-1997',
      NULL,
      1,
      NULL,
      ' 8-20-1978',
      NULL,
      0,
      NULL,
      NULL,
      1,
      84.196952,
      ' 4-10-1986',
      8,
      24.708623,
      NULL,
      8,
      ' 2-14-1993',
      36,
      0,
      147,
      ' 1-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


