set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4243',
      NULL,
      '14312101',
      '10341332',
      '23231003',
      '31331101',
      '04441131',
      NULL,
      '44423220',
      '01440311',
      '14143222',
      '40102033',
      '22314211',
      NULL,
      '24214344',
      NULL,
      '13002120',
      '20210030',
      '00102324',
      '44013404',
      NULL,
      NULL,
      NULL,
      '44200213',
      NULL,
      '03123444',
      '30414040',
      '32220024',
      '21131040',
      '30041422',
      NULL,
      NULL,
      '04023434',
      '44122433',
      '04101334',
      '40340000',
      '31131040',
      '43020330',
      '21011024',
      '13002402',
      '13332304',
      '30434123',
      '34321143',
      '00344434',
      '13004032',
      '430',
      '30',
      NULL,
      NULL,
      '2441413',
      0,
      NULL,
      NULL,
      NULL,
      '030201',
      0.846760,
      NULL,
      ' 9- 0-1979',
      69.348378,
      NULL,
      47,
      11,
      10,
      10,
      NULL,
      NULL,
      4.402027,
      1.053177,
      NULL,
      1,
      44,
      NULL,
      25.919774,
      0,
      13,
      0,
      NULL,
      1.950606,
      NULL,
      NULL,
      NULL,
      14.140819,
      0.215297,
      73.176566,
      88,
      26,
      63,
      128,
      6,
      '11-25-1996',
      33,
      5.516245,
      17,
      10.378656,
      87.750521,
      NULL,
      NULL,
      0.238348,
      1.700653,
      3.058453,
      0,
      3.907108,
      1.504612,
      NULL,
      3.770687,
      1.265364,
      1.526001,
      13.943300,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.860493,
      NULL,
      1.155400,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1990',
      36,
      10,
      10,
      NULL,
      2.718235,
      NULL,
      ' 7-24-1995',
      0.232655,
      0.255063,
      36.005219,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1982',
      7.295602,
      67.969911,
      56,
      62.017980,
      12,
      53,
      NULL,
      46,
      47.701635,
      14.392346,
      36,
      NULL,
      NULL,
      5.301448,
      4,
      NULL,
      54,
      39.714879,
      9.639267,
      0,
      ' 6- 7-1977',
      12,
      8.032833,
      '11-18-1980',
      1.871992,
      NULL,
      14,
      9,
      11.589262,
      5,
      1.999069,
      1,
      0,
      NULL,
      2,
      NULL,
      9,
      7.932841,
      1.413818,
      4,
      11,
      0,
      ' 2-18-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      1,
      ' 2-12-1991',
      NULL,
      NULL,
      NULL,
      18.899116,
      '11-21-1994',
      44,
      NULL,
      NULL,
      NULL,
      ' 4- 0-2001',
      44.381030,
      68,
      ' 7- 7-1984',
      8,
      6,
      ' 7- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      16,
      ' 7-19-1974',
      33,
      14.587050,
      10.586035,
      ' 5-25-1989',
      2.795436,
      76.230628,
      NULL,
      7,
      NULL,
      15,
      54,
      NULL,
      52,
      NULL,
      17.651625,
      ' 0-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


