set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      '3',
      '1',
      '3',
      '4',
      NULL,
      '0',
      '0',
      '2',
      '3',
      '1',
      '4',
      '1',
      '0',
      '1',
      '2',
      '0',
      '2',
      '3',
      NULL,
      '4',
      '0',
      '',
      '3',
      '',
      '2',
      '0',
      NULL,
      '0',
      '0',
      '',
      '',
      '1',
      '4',
      NULL,
      '1',
      '4',
      '1',
      '2',
      '0',
      '0',
      '0',
      '0',
      '103',
      '31',
      34.731490,
      40,
      '0322443',
      0.761612,
      104.093275,
      1,
      NULL,
      '221424',
      1,
      NULL,
      ' 4-22-1999',
      78,
      191,
      24.637224,
      NULL,
      NULL,
      8.002022,
      54.035753,
      2,
      3.247692,
      9.705932,
      25,
      3,
      2,
      11,
      3,
      4,
      2.161724,
      4,
      49.401363,
      12.074388,
      2,
      17,
      9.765289,
      NULL,
      NULL,
      NULL,
      127.032363,
      57,
      47.662155,
      38.933397,
      115.947615,
      ' 1-26-1977',
      18.193655,
      31,
      6.691249,
      5,
      194,
      77,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      31,
      7,
      3,
      3.881997,
      NULL,
      ' 0-19-1990',
      NULL,
      0.491495,
      76,
      0,
      1.346126,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      '10- 2-1977',
      6,
      5,
      48,
      35,
      9.289580,
      NULL,
      4,
      22,
      18.857384,
      41,
      57,
      NULL,
      ' 3-12-2001',
      NULL,
      16,
      19.057884,
      NULL,
      24,
      18.381081,
      9.311566,
      '11-17-1984',
      4,
      NULL,
      '11- 5-2001',
      6.599310,
      6.061462,
      5,
      1,
      19.277671,
      0.976139,
      1.422745,
      8.961728,
      0,
      32,
      1,
      4,
      3,
      11.705592,
      3.528558,
      5,
      3,
      0,
      ' 8- 1-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      '11-13-1986',
      NULL,
      NULL,
      NULL,
      30.403534,
      '11-24-1978',
      0.804439,
      '11-11-1994',
      NULL,
      8.970918,
      ' 2-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '10-21-1978',
      35,
      NULL,
      NULL,
      '11- 0-2002',
      NULL,
      11,
      NULL,
      11,
      NULL,
      19,
      21.965743,
      ' 4- 6-1985',
      20.568145,
      NULL,
      NULL,
      ' 2-13-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


