set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9201461';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3232',
      '03244013',
      '23144413',
      NULL,
      '04441230',
      '24421220',
      '32310044',
      '23224141',
      '31201413',
      '13033032',
      '33121213',
      NULL,
      '13130221',
      '42302443',
      '31212202',
      '02220312',
      NULL,
      '12120411',
      '34002222',
      '40232042',
      '32321021',
      '03442422',
      '20034404',
      '32042110',
      '34304013',
      '12110213',
      '20401443',
      '02023312',
      '11222004',
      '41222304',
      '44333001',
      '12410232',
      '14041222',
      NULL,
      '23013202',
      '43232410',
      '14103414',
      '24044143',
      '20303401',
      '41024043',
      '43021432',
      '41423421',
      '42304010',
      NULL,
      '44112004',
      '332',
      '00',
      NULL,
      NULL,
      '0231130',
      3,
      NULL,
      0,
      NULL,
      '231303',
      2,
      ' 6-12-1988',
      '11-20-1996',
      6.727879,
      NULL,
      15.797509,
      11.293952,
      14.143560,
      0.381249,
      NULL,
      0,
      19,
      1.867720,
      25,
      14,
      1,
      4.700149,
      11,
      NULL,
      3,
      NULL,
      NULL,
      14.599443,
      NULL,
      NULL,
      104.004267,
      13.353026,
      NULL,
      43,
      33.103927,
      112,
      2.435304,
      105.239435,
      36.445532,
      NULL,
      38.685512,
      22,
      14.045377,
      22.234478,
      121,
      156,
      NULL,
      0,
      1,
      1,
      1.005047,
      0.146710,
      0,
      2,
      NULL,
      1,
      1.877314,
      3.705393,
      0.027417,
      0.657208,
      0.458034,
      1.201451,
      0,
      1.026677,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      20.436249,
      8.741537,
      NULL,
      0,
      3.321826,
      ' 9- 7-1989',
      0.605011,
      1,
      78,
      1,
      4.939088,
      5.670001,
      1,
      NULL,
      NULL,
      0.457287,
      1,
      NULL,
      NULL,
      NULL,
      82.442935,
      108.539219,
      NULL,
      123.773788,
      10.835269,
      48.712478,
      85.935343,
      79.560800,
      30.676227,
      53.163706,
      53,
      ' 9-12-1984',
      NULL,
      8,
      0,
      11,
      35.600827,
      NULL,
      9.689408,
      ' 4-18-1992',
      19,
      23,
      ' 0-16-1990',
      7,
      9,
      14,
      22.209513,
      21.356908,
      0.052777,
      NULL,
      15,
      NULL,
      NULL,
      0,
      1,
      7.491112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1977',
      NULL,
      0,
      1,
      ' 5-27-1996',
      139.483752,
      1,
      ' 4- 0-1975',
      2.446341,
      5.167099,
      ' 7-12-1991',
      NULL,
      '11-22-1991',
      6,
      '11-14-1976',
      14,
      2,
      ' 1-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0.298874,
      ' 1- 8-2001',
      1,
      NULL,
      ' 3-26-1977',
      3,
      NULL,
      NULL,
      ' 2- 9-2003',
      21,
      16,
      27,
      ' 0- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


