set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0101',
      '40243343',
      '24044004',
      '00312424',
      '01044233',
      '22412023',
      '00211342',
      '31304420',
      '12444230',
      '30402131',
      '20230301',
      '44404333',
      '33034113',
      NULL,
      '41340134',
      '34413442',
      NULL,
      '41240120',
      NULL,
      NULL,
      NULL,
      '41103022',
      '31241331',
      '40243044',
      '34342400',
      '42144431',
      '32341023',
      '31404410',
      '24004103',
      '20313132',
      '14422411',
      NULL,
      '32324103',
      '13340123',
      '41411214',
      NULL,
      '13033443',
      '12443444',
      '24102330',
      '33231344',
      '33220221',
      '40414240',
      '22000233',
      '13230304',
      '03234420',
      '431',
      '43',
      NULL,
      NULL,
      '2201134',
      3,
      0,
      2,
      NULL,
      '300343',
      0.327016,
      ' 2-29-1995',
      ' 4-23-1979',
      2.540008,
      NULL,
      1,
      10,
      24.410087,
      0.809140,
      42.638769,
      5.441061,
      15.886859,
      12.579902,
      NULL,
      16.794715,
      4,
      3,
      10.639647,
      6.631426,
      NULL,
      13,
      NULL,
      10,
      NULL,
      NULL,
      3,
      6,
      1,
      68,
      135,
      22,
      78.447095,
      45,
      134.912802,
      ' 7- 0-1998',
      20.203339,
      8.060216,
      22.417987,
      NULL,
      38.093212,
      13.848290,
      NULL,
      0.757715,
      0.692531,
      0,
      1,
      3.324510,
      3.181422,
      3,
      NULL,
      0.860448,
      1.683941,
      0,
      1.579430,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-23-2003',
      0.255025,
      18.904636,
      5.251507,
      5,
      1.302449,
      6,
      ' 0-15-1987',
      NULL,
      0,
      74.187899,
      NULL,
      0.502382,
      89.832815,
      0,
      5.102971,
      53.251377,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1977',
      58.593494,
      26,
      62.184879,
      9,
      34.803354,
      36.007967,
      14.603987,
      59.014847,
      38.305456,
      25,
      4.017762,
      46,
      ' 6-15-1997',
      NULL,
      11,
      NULL,
      45.240911,
      24.628880,
      30.858459,
      2.394725,
      ' 1-29-1992',
      19,
      16,
      ' 5-25-2003',
      NULL,
      13.642440,
      14,
      4,
      NULL,
      5.807417,
      1,
      5.431625,
      1,
      18.747282,
      NULL,
      NULL,
      13,
      13.119115,
      1,
      1.813293,
      0,
      0.344701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      ' 5-29-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-1999',
      12,
      ' 4-18-1990',
      NULL,
      4.314498,
      ' 4-25-1977',
      13,
      36.025010,
      '11-15-1997',
      7,
      1,
      '10- 1-2002',
      NULL,
      NULL,
      NULL,
      1,
      0,
      15,
      ' 1-18-2002',
      11.521729,
      10.167240,
      20.760873,
      NULL,
      1,
      68.183931,
      NULL,
      3.476383,
      191.585587,
      1,
      160,
      ' 3-29-1986',
      24,
      0,
      205,
      ' 2- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


