set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4312',
      '33034332',
      '42402311',
      '13121124',
      '04340313',
      '10432102',
      '22433431',
      '04421044',
      '22114202',
      NULL,
      '00042212',
      '30334310',
      '24443214',
      '42140320',
      '03043120',
      '00130042',
      '02021342',
      NULL,
      NULL,
      '22013114',
      '11204443',
      NULL,
      '41412301',
      '33221334',
      NULL,
      '04330223',
      NULL,
      '11404002',
      '14111003',
      '23131201',
      NULL,
      '24240020',
      '03403431',
      '32414043',
      '01134144',
      '03001124',
      NULL,
      '13331304',
      '30033104',
      '03044313',
      '10431424',
      NULL,
      NULL,
      NULL,
      '02134324',
      '312',
      NULL,
      NULL,
      24.757927,
      '1303141',
      NULL,
      34.688790,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1975',
      '11-29-1993',
      120,
      21.773143,
      NULL,
      NULL,
      4,
      15,
      16,
      13.895854,
      1.061956,
      NULL,
      30,
      22.668814,
      7.999413,
      1,
      1.228303,
      12,
      NULL,
      16.638741,
      12.328315,
      17.780631,
      51.597453,
      13.967819,
      90,
      NULL,
      1.890400,
      59.723225,
      27,
      56,
      12,
      164,
      NULL,
      ' 3-15-1995',
      NULL,
      13,
      NULL,
      20,
      NULL,
      40.272831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      6,
      3,
      11,
      6.409210,
      ' 4-20-2001',
      1,
      NULL,
      38.532829,
      NULL,
      0,
      73.195930,
      0,
      4.571099,
      0,
      NULL,
      NULL,
      NULL,
      ' 4-13-1987',
      9,
      NULL,
      52.054047,
      58,
      NULL,
      78.857700,
      NULL,
      33,
      32.934679,
      68,
      NULL,
      34,
      ' 0- 0-2002',
      21.762196,
      14.269109,
      1.516407,
      33.510020,
      41,
      10.945001,
      2,
      ' 0-14-1978',
      5,
      32,
      '11-17-2003',
      3.919194,
      2.126984,
      31,
      8.570417,
      NULL,
      12,
      0,
      3.460445,
      NULL,
      58.172231,
      NULL,
      NULL,
      26.339334,
      10.175455,
      0.074595,
      0,
      0.794917,
      0.908436,
      ' 9-24-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      13,
      ' 6- 5-1991',
      NULL,
      NULL,
      NULL,
      21,
      ' 4- 4-1978',
      NULL,
      ' 2-21-1998',
      6,
      5,
      ' 4- 4-1992',
      16,
      118,
      ' 8- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      24.394053,
      '10-17-1999',
      51,
      NULL,
      5,
      ' 7-19-1976',
      0.643424,
      55,
      ' 5-21-1998',
      NULL,
      43.328486,
      11.317631,
      20,
      ' 9-29-1982',
      69.007922,
      NULL,
      75.933677,
      ' 1-19-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


