set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '1',
      '3',
      '1',
      '1',
      '4',
      NULL,
      '3',
      '1',
      '3',
      '3',
      '3',
      '0',
      '2',
      '1',
      '0',
      '0',
      '4',
      '2',
      '4',
      '2',
      '0',
      '2',
      NULL,
      '3',
      '',
      NULL,
      '2',
      NULL,
      NULL,
      '3',
      NULL,
      '',
      '4',
      '4',
      '4',
      '3',
      '1',
      '4',
      '1',
      '3',
      '0',
      '2',
      '2',
      '220',
      '11004444',
      35.121505,
      14,
      '1041021',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5.895065,
      ' 7-27-2000',
      ' 0- 0-1977',
      NULL,
      68.615807,
      27.502608,
      NULL,
      20,
      10.515643,
      NULL,
      7.398877,
      NULL,
      19,
      23,
      9.188666,
      31.554131,
      7.508235,
      10.676681,
      NULL,
      29,
      0.711743,
      16.706730,
      8.796655,
      50.384737,
      2,
      88,
      10.861058,
      0,
      23.072421,
      87.971428,
      NULL,
      119.510576,
      10.120569,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      116.655272,
      NULL,
      ' 0- 5-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81.609516,
      28,
      4,
      13.791413,
      2,
      6,
      ' 7-22-1990',
      NULL,
      NULL,
      179.258097,
      1,
      0,
      NULL,
      NULL,
      0.589738,
      83,
      NULL,
      NULL,
      NULL,
      ' 9- 3-2002',
      73.006421,
      NULL,
      NULL,
      86,
      NULL,
      64,
      NULL,
      3.715246,
      NULL,
      17.299334,
      41,
      56,
      '10- 4-1992',
      1,
      2.014336,
      10,
      23.005119,
      35.411919,
      5.997967,
      4.437683,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1976',
      2,
      NULL,
      23.375252,
      16,
      13,
      6,
      NULL,
      0.834700,
      1,
      114.049225,
      0.496733,
      0.551851,
      12.191562,
      NULL,
      1,
      2.931895,
      0,
      1.931338,
      ' 9- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      17.199055,
      10.895575,
      ' 6-18-1998',
      NULL,
      NULL,
      NULL,
      28,
      ' 3-26-1993',
      48.335383,
      ' 7-19-1995',
      9,
      15,
      '10-13-1978',
      120.935329,
      NULL,
      ' 2-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      21.919066,
      ' 3-22-1999',
      45,
      17,
      20.996037,
      ' 0-15-1984',
      0,
      215.879691,
      ' 6-13-1994',
      4.047814,
      NULL,
      7.280321,
      43.562176,
      ' 4-22-1986',
      32.937289,
      0.467303,
      19,
      ' 2-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


