set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007121';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '0',
      '1',
      '0',
      '2',
      '3',
      '1',
      '4',
      NULL,
      '0',
      '2',
      '2',
      '4',
      '3',
      NULL,
      '0',
      '1',
      '2',
      NULL,
      '0',
      '2',
      NULL,
      '4',
      '',
      '1',
      '',
      '4',
      '4',
      '3',
      '3',
      NULL,
      NULL,
      '',
      NULL,
      '0',
      '1',
      '0',
      '0',
      '0',
      NULL,
      '2',
      '3',
      '1',
      '0',
      '021',
      '30',
      22.753263,
      NULL,
      '1110233',
      2.292445,
      1,
      NULL,
      NULL,
      '004204',
      5.728748,
      ' 7-11-1980',
      '10-11-1989',
      33,
      NULL,
      26.400880,
      0.503137,
      13,
      22,
      NULL,
      13,
      7.696316,
      NULL,
      0.940440,
      NULL,
      NULL,
      3.734317,
      4.237896,
      12.183426,
      0.836660,
      7,
      58,
      NULL,
      48,
      NULL,
      17,
      15.975165,
      0.340130,
      NULL,
      110.743215,
      12,
      103,
      120,
      99,
      '11-18-2002',
      46.110115,
      64.626525,
      7,
      19.610734,
      184,
      17.073390,
      ' 5-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      1.626009,
      0.420652,
      16.525845,
      0,
      9.104808,
      ' 3-12-1998',
      1.477235,
      1.159718,
      247.406408,
      0.443654,
      4.681781,
      128,
      1.046928,
      0.226963,
      22,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1979',
      12.007794,
      4.982044,
      69.989714,
      91,
      NULL,
      NULL,
      42.863173,
      NULL,
      6,
      0.072778,
      7.941674,
      60.786958,
      '11-24-1974',
      27,
      32.023936,
      7.446786,
      93.374273,
      53,
      158.282842,
      13.226688,
      ' 5-13-2000',
      33.690483,
      24.357475,
      '10- 4-2000',
      19,
      21.108125,
      7.230484,
      1,
      21,
      16,
      NULL,
      4,
      0,
      39.888518,
      0.741726,
      5,
      31.188667,
      4,
      0,
      0.354374,
      0.108765,
      NULL,
      ' 3-24-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      206,
      NULL,
      ' 3-24-1990',
      NULL,
      NULL,
      NULL,
      42.508778,
      ' 7-13-1998',
      35.740062,
      '10- 2-1987',
      18.880250,
      NULL,
      ' 1- 1-1977',
      NULL,
      131,
      ' 9- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      12,
      ' 4-13-1988',
      5.309024,
      16,
      39,
      ' 7- 8-2001',
      0,
      77,
      '10-25-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


