set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9785872';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '1',
      '4',
      '1',
      '3',
      '0',
      '0',
      '1',
      '4',
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      '3',
      '1',
      '1',
      '1',
      '2',
      '4',
      '',
      '3',
      '',
      NULL,
      '3',
      '3',
      '2',
      '0',
      '',
      '',
      '3',
      '2',
      '0',
      '4',
      '1',
      NULL,
      '3',
      NULL,
      '3',
      '3',
      '4',
      '413',
      '13444443',
      43,
      12,
      '3041230',
      NULL,
      1.250735,
      3,
      NULL,
      NULL,
      4.165075,
      '10- 9-1986',
      '11-29-1990',
      NULL,
      207.024976,
      40,
      27,
      NULL,
      27.997201,
      100.057072,
      7.545953,
      28,
      3.096462,
      14,
      29.752391,
      28.955289,
      22,
      1,
      24,
      1,
      21,
      60,
      17.713246,
      34,
      20.516944,
      NULL,
      24,
      NULL,
      160.910649,
      206,
      2,
      163.352357,
      79.590542,
      151,
      ' 3-13-2000',
      31,
      NULL,
      20.623964,
      NULL,
      26.924213,
      117.520575,
      ' 0- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.252529,
      NULL,
      6.472791,
      5.215830,
      NULL,
      NULL,
      ' 8- 6-1999',
      1,
      1.086827,
      6,
      1.167559,
      0.947045,
      117,
      1.508344,
      1,
      73,
      NULL,
      NULL,
      NULL,
      ' 7-19-1990',
      85.227096,
      86,
      NULL,
      43.525802,
      57,
      16.097260,
      33.777438,
      50.691904,
      78.201973,
      49,
      25.819533,
      73,
      ' 9- 2-1979',
      NULL,
      15.987403,
      21,
      109,
      71.213124,
      NULL,
      4,
      NULL,
      19,
      16.517005,
      '11-28-1993',
      2.257829,
      9.247022,
      NULL,
      18.485016,
      13.149329,
      4.415529,
      0.092613,
      11,
      1.895499,
      158.171275,
      0.101981,
      5.094858,
      15,
      NULL,
      NULL,
      0.928455,
      0,
      1.522218,
      ' 8-29-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      277,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-10-2000',
      NULL,
      NULL,
      4,
      1.881321,
      NULL,
      105.918794,
      99.016358,
      ' 3-16-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      27.441022,
      ' 1-20-1976',
      56.575408,
      25,
      56.627108,
      ' 3- 0-1990',
      0.786048,
      75.477712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


