set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0330',
      '23211320',
      '44122434',
      NULL,
      '04140440',
      '21030033',
      '34244142',
      '32122434',
      '03134103',
      '31222004',
      '13443122',
      '14441100',
      NULL,
      '00322212',
      NULL,
      '00300320',
      '44002314',
      '22303014',
      '04242214',
      '14443012',
      '14033041',
      '14222143',
      '24421141',
      '04203104',
      '24001202',
      '20124010',
      '43124114',
      '10413244',
      '33024420',
      '11144133',
      '34444020',
      '44342213',
      '40434304',
      '31014243',
      '34110442',
      '42301222',
      '34024330',
      '04130132',
      '03241130',
      '13200110',
      '10304021',
      '13401312',
      '23024311',
      '41311003',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4414430',
      1.177923,
      NULL,
      1,
      NULL,
      '403443',
      0,
      ' 1-27-1988',
      ' 3- 6-1989',
      53.169089,
      NULL,
      12.542633,
      NULL,
      11,
      14,
      NULL,
      5.424512,
      6,
      2,
      NULL,
      1.690171,
      5,
      NULL,
      0.354171,
      2,
      2,
      0,
      NULL,
      9,
      0,
      2,
      95,
      18.253820,
      NULL,
      41.944311,
      12.688953,
      7,
      20,
      45.182038,
      NULL,
      ' 4- 7-1999',
      26,
      18,
      11.164707,
      NULL,
      129.947572,
      NULL,
      ' 4-18-1991',
      6,
      NULL,
      10.196547,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2.047994,
      0,
      1.696004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1977',
      102,
      133,
      22,
      58,
      NULL,
      14,
      110,
      NULL,
      54,
      117.914078,
      88.768375,
      52,
      ' 4- 7-1977',
      7.138017,
      10.274481,
      6.965197,
      11.814711,
      NULL,
      NULL,
      NULL,
      ' 0-11-1974',
      NULL,
      NULL,
      NULL,
      0,
      2.178110,
      7.209420,
      6.404831,
      20,
      5,
      NULL,
      1,
      NULL,
      20.613395,
      3.230256,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4.666564,
      80,
      ' 4- 6-1985',
      12.382976,
      36,
      NULL,
      33,
      ' 4- 6-1977',
      NULL,
      0.309121,
      NULL,
      ' 5-16-1984',
      NULL,
      NULL,
      NULL,
      42.792845,
      14,
      35.513594,
      14,
      25,
      59,
      125.239265,
      89.898528,
      44.822729,
      105,
      1.371718,
      4,
      NULL,
      NULL,
      109.336791,
      1,
      1,
      NULL,
      1.745651,
      1.098405,
      77,
      1.823134,
      0.931890,
      174,
      58,
      25,
      56,
      NULL,
      13,
      NULL,
      1.717477,
      1,
      0,
      0.612970,
      1.927640,
      35,
      37.310070,
      12.036913,
      5.618332,
      9.240094,
      29.093749,
      0,
      1.239975,
      NULL,
      1,
      0,
      4,
      17.155352,
      NULL,
      52.178726,
      1.161353,
      41,
      NULL,
      0.811669,
      39,
      9.924986,
      2.646470,
      11.302813,
      16.365370,
      NULL,
      3,
      42.557280,
      10,
      3.493076,
      0,
      4.928052,
      3,
      0.075423,
      0,
      2,
      57.916156,
      NULL,
      ' 3-25-1979',
      NULL,
      ' 2-26-1978',
      ' 9-18-1982',
      ' 2-11-1976',
      NULL,
      NULL);
commit;
end;
/


