set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01314124',
      '21101341',
      '11003223',
      NULL,
      '33330404',
      '30032114',
      '43303421',
      '03304004',
      '00101104',
      '24120304',
      '20431204',
      '10130443',
      '12130000',
      '20204404',
      '04040203',
      NULL,
      '31121221',
      '30101411',
      '43322023',
      '12020221',
      '13404332',
      NULL,
      '43424432',
      NULL,
      '03132401',
      NULL,
      '44002414',
      '33102103',
      '43231443',
      NULL,
      '00140112',
      '41033211',
      '30142303',
      '10012112',
      NULL,
      '00404001',
      '13021212',
      '03340102',
      '14341334',
      '21212231',
      '10300314',
      NULL,
      '42422312',
      NULL,
      '034',
      '33',
      NULL,
      NULL,
      '0112321',
      NULL,
      NULL,
      1,
      NULL,
      '223023',
      4,
      ' 9- 9-1990',
      '10- 1-1979',
      18.923894,
      NULL,
      18.174775,
      1,
      15,
      19.095629,
      0,
      2.088170,
      3.612619,
      9,
      16,
      6.705793,
      7.075289,
      2.466191,
      23,
      NULL,
      NULL,
      4,
      12.104252,
      7,
      53,
      2,
      NULL,
      12,
      2.715164,
      NULL,
      17,
      NULL,
      NULL,
      133,
      35,
      ' 5-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      6.194953,
      NULL,
      2,
      0,
      1,
      0.066989,
      4,
      0,
      1,
      0,
      0.549910,
      1.430723,
      1,
      1.762519,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-1996',
      25.412937,
      NULL,
      NULL,
      2.277549,
      15,
      NULL,
      '11-11-1978',
      NULL,
      NULL,
      19,
      0.643629,
      2.251882,
      NULL,
      0.091516,
      3.366624,
      72.634817,
      NULL,
      1.836182,
      123.877508,
      ' 1-25-1996',
      NULL,
      106,
      47,
      14,
      NULL,
      84.240425,
      10.028261,
      28.726398,
      10.095490,
      0.318001,
      NULL,
      52.825931,
      ' 8-20-1989',
      4,
      13,
      NULL,
      NULL,
      42.961949,
      NULL,
      5.191977,
      ' 0-20-1991',
      NULL,
      10,
      ' 1-12-1979',
      2,
      9.602696,
      2.488897,
      5.314194,
      NULL,
      4.606698,
      0.932375,
      NULL,
      NULL,
      34.398395,
      2,
      0.953775,
      0.238005,
      1.583733,
      5,
      5,
      0.861190,
      0,
      ' 6-15-1984',
      0.939164,
      2.835046,
      1,
      ' 7- 2-1997',
      155,
      NULL,
      ' 0- 9-1976',
      NULL,
      NULL,
      NULL,
      26,
      ' 5- 3-1998',
      42.140043,
      ' 9-24-1985',
      NULL,
      3.737415,
      ' 6-26-1987',
      108.551042,
      47.107661,
      NULL,
      1.649932,
      1.114365,
      ' 7- 1-1991',
      3,
      NULL,
      ' 1-17-2000',
      NULL,
      NULL,
      16.317313,
      NULL,
      0.271397,
      16.564092,
      NULL,
      NULL,
      0.643516,
      60,
      '11-11-2000',
      9.744936,
      112,
      NULL,
      11,
      ' 6-21-1992',
      61,
      0.072284,
      2,
      ' 0-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


