set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8820929';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0341',
      '42410433',
      '01112013',
      '10241320',
      NULL,
      '01200221',
      NULL,
      NULL,
      NULL,
      '04232412',
      NULL,
      '03023341',
      '23023103',
      '34103034',
      '41410043',
      '30334312',
      NULL,
      '30242211',
      '32023110',
      '34214411',
      '31043143',
      '24101010',
      '01233421',
      '31431131',
      '42224113',
      '40334244',
      '13014212',
      '23401244',
      '12232302',
      '00440402',
      '42012111',
      '40420240',
      '44040124',
      '34434042',
      NULL,
      '04002201',
      NULL,
      '21331233',
      '02010300',
      '21102414',
      NULL,
      '22204410',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717589,
      1,
      NULL,
      '203042',
      2.054043,
      ' 5- 1-1974',
      ' 5-23-1986',
      82.965284,
      NULL,
      17.655349,
      NULL,
      17.535527,
      NULL,
      40.546986,
      14,
      10,
      10,
      40.612289,
      6.269301,
      26,
      2,
      35.176263,
      23,
      6,
      4.215041,
      11,
      NULL,
      42,
      18,
      86,
      2,
      NULL,
      65,
      27,
      57,
      130,
      23,
      49.859325,
      ' 1-22-2001',
      NULL,
      44,
      9,
      25.043793,
      131.351343,
      131,
      ' 9-25-1985',
      3,
      2,
      1.698329,
      1.525162,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270245,
      1.205698,
      1.923047,
      0,
      1,
      1.863342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-2001',
      54,
      44.587540,
      7.500012,
      64.533396,
      52,
      NULL,
      NULL,
      12.384272,
      NULL,
      10,
      33,
      25,
      ' 0-22-2002',
      22.284508,
      17.238936,
      NULL,
      53,
      36,
      92.559545,
      11.467493,
      NULL,
      6,
      NULL,
      NULL,
      11.301470,
      NULL,
      0,
      25,
      21,
      NULL,
      NULL,
      21.960256,
      NULL,
      75,
      13.463306,
      15.769829,
      3.041119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.190918,
      NULL,
      9,
      ' 6-26-1992',
      1.068844,
      28.735349,
      '10-18-2002',
      0.878606,
      8,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923283,
      1,
      51.252569,
      1,
      1,
      39,
      1.798711,
      3,
      18,
      0.478809,
      NULL,
      190.809067,
      NULL,
      1.341059,
      NULL,
      1.454076,
      NULL,
      NULL,
      0,
      1.118405,
      NULL,
      NULL,
      1.920665,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1,
      0.656310,
      0,
      0.725690,
      3.019282,
      1,
      5,
      1,
      NULL,
      1,
      NULL,
      0,
      3.670706,
      NULL,
      20.409942,
      9,
      9.873628,
      NULL,
      NULL,
      13.416915,
      NULL,
      1.610310,
      3,
      1.361782,
      2,
      0.277066,
      NULL,
      0,
      0,
      NULL,
      NULL,
      ' 7-27-1998',
      ' 0- 5-1978',
      ' 3-27-2003',
      ' 7-23-1989',
      '11-16-1990',
      ' 4- 6-2003',
      NULL);
commit;
end;
/


