set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9688133';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '42243332',
      '00430323',
      NULL,
      '42022441',
      '02413300',
      '30231310',
      '30443330',
      '41223334',
      '22400404',
      '34244114',
      '01123042',
      '43031434',
      NULL,
      '44430313',
      '03220430',
      '14211434',
      '43300411',
      '03244322',
      '44234232',
      '40000332',
      '10420213',
      NULL,
      NULL,
      '11430040',
      '11320212',
      NULL,
      '22424134',
      '40214220',
      '41333132',
      '10213111',
      '34021031',
      '10313434',
      '41230011',
      '14211434',
      '43042301',
      '01110324',
      '14131144',
      '32431332',
      NULL,
      '13244344',
      '42124011',
      '22111441',
      '221',
      '02',
      11,
      14,
      '0002220',
      0.610125,
      1.466594,
      2,
      NULL,
      '310040',
      1,
      ' 9-24-1988',
      ' 4-18-2000',
      7.446243,
      65,
      21,
      4,
      NULL,
      13.117800,
      101,
      10.599648,
      1.938119,
      NULL,
      NULL,
      NULL,
      43.999957,
      8,
      NULL,
      6.728432,
      38,
      NULL,
      NULL,
      15.709262,
      49,
      NULL,
      27.213412,
      6.142081,
      1,
      61.759190,
      28.666983,
      130.955495,
      99.211386,
      NULL,
      137,
      NULL,
      54,
      10,
      36.012381,
      NULL,
      147.617426,
      142,
      '10-22-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.445275,
      NULL,
      7.746415,
      4.132116,
      3.058115,
      NULL,
      ' 7-12-1984',
      NULL,
      0,
      212,
      1.585536,
      1.263953,
      140,
      0,
      1.231487,
      55,
      NULL,
      NULL,
      NULL,
      ' 5-21-1990',
      44,
      67,
      NULL,
      99,
      53.339353,
      32.681629,
      15,
      84,
      53,
      29.809242,
      57,
      57.800972,
      ' 7- 8-1998',
      3.055486,
      NULL,
      5,
      16.663127,
      21.955121,
      NULL,
      7.139522,
      ' 3-26-1981',
      8.118933,
      11,
      NULL,
      NULL,
      14,
      20.161126,
      12,
      17,
      NULL,
      0.238354,
      7,
      NULL,
      121.271501,
      1,
      0.157084,
      12.438365,
      NULL,
      2.625624,
      1,
      NULL,
      0.125881,
      ' 2- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      151.001357,
      3.038621,
      ' 8-16-1989',
      NULL,
      NULL,
      NULL,
      31,
      ' 8-29-1994',
      19.780685,
      ' 7- 8-1984',
      11.062979,
      2,
      ' 2-26-1980',
      11.122108,
      NULL,
      ' 2-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7,
      NULL,
      60.421308,
      26.145626,
      NULL,
      '10-22-2002',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


