set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300487';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3322',
      '11244302',
      '34300144',
      '32312013',
      '22411344',
      NULL,
      '23412301',
      '02233212',
      '04132022',
      '40312404',
      '13243000',
      '30124424',
      '44004311',
      '42144233',
      '23323002',
      '13402234',
      '14424030',
      '41430213',
      '22113134',
      '22203410',
      '43232013',
      '00334422',
      NULL,
      '12304310',
      '31034443',
      '11210202',
      '41403102',
      '00434231',
      NULL,
      '43443241',
      '01443342',
      NULL,
      '04122142',
      '02131140',
      '34340044',
      '01441114',
      '32230044',
      '11110311',
      '23214110',
      '10412342',
      '24304302',
      '12214333',
      '00342434',
      '11144313',
      '23001222',
      '044',
      NULL,
      NULL,
      NULL,
      '4431330',
      1.820544,
      0.521176,
      0,
      NULL,
      '441213',
      NULL,
      ' 7-17-1976',
      NULL,
      25,
      NULL,
      5.477226,
      7,
      15.108971,
      27,
      79,
      NULL,
      NULL,
      NULL,
      33,
      13.961487,
      5,
      9.273587,
      21,
      NULL,
      6,
      9.149230,
      38.991659,
      21,
      37.940801,
      5.088636,
      27.496708,
      10,
      0.907086,
      115.574709,
      11.909300,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1996',
      40.335229,
      52,
      35,
      29.474928,
      165,
      23,
      ' 4- 1-1981',
      0,
      3,
      0.910911,
      0.401097,
      NULL,
      NULL,
      1.230740,
      1,
      1,
      0.141320,
      0,
      NULL,
      1.798464,
      1,
      1.054358,
      0.592828,
      1.893612,
      0,
      0.777488,
      0.874354,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-1980',
      0,
      0,
      8,
      7.449596,
      3.974576,
      0.545666,
      '10- 8-1976',
      NULL,
      0,
      20,
      2,
      NULL,
      NULL,
      1,
      1.081779,
      42.601774,
      1,
      0,
      44,
      NULL,
      40.991916,
      47.366811,
      29,
      47.333787,
      89,
      63,
      107,
      NULL,
      91,
      29,
      53.297917,
      109.172398,
      NULL,
      20,
      9.885536,
      12,
      12.380445,
      48.580931,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-2000',
      8,
      14,
      20,
      1.448865,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      63.560719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-26-1974',
      NULL,
      0.781604,
      NULL,
      NULL,
      72.154569,
      3,
      ' 4- 0-1985',
      9.224895,
      3,
      NULL,
      40,
      ' 1-10-1997',
      42.808144,
      NULL,
      20,
      5.160972,
      ' 1-18-1982',
      196.698443,
      45,
      '11-22-1978',
      NULL,
      0,
      ' 9-13-1985',
      NULL,
      7.036832,
      NULL,
      1,
      2,
      6,
      ' 4- 6-1983',
      48.836637,
      47.017935,
      14.768910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.343287);
commit;
end;
/


