set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028621';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1012',
      NULL,
      '04441144',
      NULL,
      '42140141',
      '30440232',
      '22313202',
      '03243030',
      '31440422',
      '13232312',
      NULL,
      '40030134',
      '21403134',
      '34233424',
      '03202212',
      '24331101',
      '43311420',
      '00433030',
      '44101122',
      '10302130',
      NULL,
      '21442130',
      '23022242',
      '43103031',
      '10031430',
      '41133214',
      '01443304',
      '44113432',
      '20322013',
      '22113301',
      '32044414',
      '24004430',
      '21033430',
      '22042230',
      '11021302',
      NULL,
      '02131104',
      NULL,
      '30013442',
      '24104033',
      '21431142',
      '20121114',
      '11200403',
      '01220123',
      '42333321',
      '402',
      '42',
      25.195976,
      10,
      NULL,
      1.698490,
      0.439094,
      NULL,
      NULL,
      '003031',
      3,
      ' 7- 3-1983',
      ' 1-16-1992',
      32,
      96.881768,
      NULL,
      13.653423,
      21.320082,
      14.514622,
      30,
      13.571162,
      NULL,
      9,
      8.640797,
      7.515771,
      12,
      1.386594,
      12,
      11.621713,
      27,
      10,
      30.931641,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0.933853,
      10.560360,
      127.272448,
      25,
      10,
      168.372537,
      8,
      ' 1-22-1977',
      22,
      40,
      7.070397,
      27,
      1,
      NULL,
      ' 1- 8-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      2.965747,
      3.804951,
      7,
      1,
      ' 9- 4-1987',
      0,
      0,
      100,
      1.958308,
      3,
      44,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1975',
      52,
      12,
      36.339009,
      27.184683,
      99.328023,
      NULL,
      6,
      17.864686,
      38,
      67,
      NULL,
      NULL,
      ' 9-20-1978',
      8,
      2,
      20.614492,
      21.972368,
      53.456382,
      NULL,
      1.876366,
      ' 2-11-1984',
      2.774984,
      NULL,
      '10-19-1987',
      8.530949,
      15.627288,
      11.548107,
      17,
      21.437729,
      9.456894,
      NULL,
      12,
      0,
      31,
      NULL,
      1,
      2.807520,
      11.699659,
      0,
      3.885417,
      7.297367,
      3,
      ' 5- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      ' 2-15-1986',
      NULL,
      NULL,
      NULL,
      38.324451,
      ' 9-11-1986',
      NULL,
      ' 5- 6-1985',
      1.337553,
      3.496451,
      ' 2- 0-2001',
      96.796695,
      0,
      ' 8-10-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      10,
      ' 5-18-1995',
      62.742844,
      NULL,
      25,
      '11-19-1997',
      NULL,
      53.872451,
      NULL,
      6,
      28.709995,
      6.982815,
      10.881827,
      ' 6-25-1974',
      33,
      1,
      66.527699,
      ' 1-24-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


