set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028621';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '12011241',
      '11400120',
      NULL,
      '13010111',
      '13314201',
      '13230342',
      '32112204',
      '04114420',
      '22000044',
      '30324430',
      '42343042',
      '10231301',
      '42313231',
      '42131213',
      '00200142',
      '22040440',
      '42210112',
      NULL,
      '40203242',
      '23120323',
      '30231133',
      '14334321',
      NULL,
      '04110341',
      '31044102',
      '43421142',
      '14413034',
      '20420430',
      '02012124',
      '04331004',
      '14230140',
      '33211232',
      '04331313',
      '31010423',
      '10300214',
      '23021440',
      '41002404',
      '44144244',
      '31341130',
      '20021023',
      '21002114',
      '20200312',
      '23132204',
      '414',
      '00',
      33.469663,
      22.174499,
      '1410321',
      3.513357,
      19.723303,
      1,
      NULL,
      NULL,
      5,
      NULL,
      '11-19-1979',
      10.572444,
      NULL,
      28.857745,
      2,
      9.329788,
      8.564589,
      40.649637,
      14,
      NULL,
      1.988828,
      19.063426,
      5,
      35.012009,
      NULL,
      13,
      NULL,
      7,
      16,
      NULL,
      4.757116,
      42,
      19.974930,
      11.318186,
      18,
      0,
      40.220772,
      NULL,
      75,
      60.972387,
      99,
      111.282486,
      NULL,
      51,
      38,
      2.458292,
      6,
      132.264810,
      61.939402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.112667,
      3,
      9,
      NULL,
      5.817927,
      1,
      ' 5- 0-1995',
      NULL,
      1.969954,
      112.383371,
      1,
      1,
      NULL,
      0.326634,
      0,
      28,
      NULL,
      NULL,
      NULL,
      ' 6- 0-1980',
      NULL,
      NULL,
      52,
      57,
      11.260738,
      NULL,
      32,
      36,
      49,
      95,
      80,
      23.083984,
      ' 0-22-1992',
      15.602511,
      5.997662,
      10.362718,
      21,
      17,
      NULL,
      7.077162,
      NULL,
      18.016612,
      18,
      ' 3-12-2000',
      8.271152,
      1.118854,
      6,
      4.222164,
      24,
      14,
      0.207069,
      15,
      NULL,
      75.706131,
      0,
      NULL,
      5.065851,
      12,
      NULL,
      12,
      2,
      1.914514,
      ' 2-21-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      206.926908,
      8.798045,
      NULL,
      NULL,
      NULL,
      NULL,
      6.414611,
      ' 6- 0-1984',
      46.765808,
      ' 5- 0-1978',
      10,
      13.845408,
      ' 6-26-1987',
      1.875824,
      NULL,
      ' 4- 9-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.419919,
      ' 0-27-1978',
      69.024866,
      2,
      NULL,
      ' 9-12-1991',
      0,
      NULL,
      ' 9-10-1997',
      2.950447,
      7.365648,
      17,
      41,
      ' 8-26-1985',
      29,
      1,
      21,
      ' 1- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


