set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028621';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      '4',
      '1',
      '4',
      '1',
      '0',
      '4',
      '2',
      '2',
      '2',
      '3',
      '2',
      NULL,
      '1',
      NULL,
      '2',
      NULL,
      '2',
      '4',
      '3',
      '4',
      '2',
      '',
      '1',
      '',
      '4',
      '1',
      NULL,
      NULL,
      '4',
      '',
      '',
      '2',
      '3',
      '4',
      NULL,
      '1',
      '4',
      '1',
      NULL,
      '1',
      '3',
      '4',
      '031',
      '33411304',
      25,
      3,
      '1404144',
      NULL,
      NULL,
      2,
      NULL,
      '010132',
      3,
      ' 0-22-1985',
      ' 6-17-1993',
      46.527781,
      91,
      2.076433,
      1,
      24.426889,
      3.024503,
      26,
      NULL,
      NULL,
      14.263370,
      7.415552,
      14.555809,
      20.856276,
      7,
      19,
      3,
      18.508986,
      4.107007,
      59.310996,
      2.606263,
      NULL,
      NULL,
      13,
      NULL,
      1.833862,
      44.819516,
      NULL,
      118.388951,
      44.181777,
      25,
      110.899462,
      ' 6-15-1983',
      NULL,
      61,
      11,
      31,
      52,
      224,
      ' 4- 8-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.145186,
      1,
      7.616982,
      2.527160,
      5,
      7,
      ' 5-23-2000',
      0,
      0.902956,
      NULL,
      NULL,
      NULL,
      100.168750,
      1.912206,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      ' 8- 8-2003',
      11,
      NULL,
      NULL,
      94.171744,
      15,
      40.420587,
      75,
      NULL,
      81.233823,
      56.232332,
      36,
      32.651199,
      '10- 4-1993',
      9.546191,
      5,
      13,
      24,
      34.624841,
      3,
      5,
      ' 6- 1-1978',
      22,
      25.527420,
      ' 7-17-1995',
      1,
      13.984893,
      20,
      23,
      3.629757,
      8.953049,
      1,
      NULL,
      1,
      111.812678,
      0,
      0.565190,
      4,
      10,
      1,
      1.820853,
      1.977856,
      1.545747,
      ' 3-14-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      5,
      ' 4-11-1989',
      NULL,
      NULL,
      NULL,
      5.666880,
      ' 4-29-2003',
      19.686888,
      NULL,
      1,
      7.725863,
      ' 9-16-1978',
      NULL,
      52.592449,
      ' 9-29-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      11,
      ' 8-15-1988',
      31,
      33,
      5,
      ' 0-25-1983',
      3,
      42.461482,
      '11-16-1999',
      NULL,
      39,
      0.823173,
      21.288148,
      ' 3-23-1979',
      6,
      NULL,
      42.258495,
      ' 6-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


