set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028621';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '4',
      '2',
      '0',
      '2',
      '3',
      '3',
      '0',
      '4',
      '4',
      '3',
      '0',
      NULL,
      '2',
      '0',
      '0',
      '4',
      '4',
      NULL,
      NULL,
      '3',
      NULL,
      '4',
      '',
      NULL,
      '',
      '0',
      '0',
      NULL,
      '3',
      NULL,
      '',
      '',
      '3',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      '3',
      NULL,
      '0',
      NULL,
      '4',
      '123',
      '31043210',
      78,
      NULL,
      '3001120',
      NULL,
      NULL,
      3,
      1,
      '102300',
      4.246792,
      ' 7-21-1994',
      ' 7- 5-1984',
      102.193641,
      274.561925,
      14.866088,
      0.134388,
      21,
      11,
      22.505444,
      NULL,
      14,
      NULL,
      23,
      17.326622,
      12.243269,
      0.165239,
      NULL,
      2,
      0,
      20.970339,
      88.870519,
      NULL,
      43,
      30,
      64.049147,
      5.847570,
      1,
      76,
      NULL,
      121,
      16.469644,
      104.646684,
      44.281782,
      '11- 6-1979',
      1.103888,
      NULL,
      4.306509,
      13,
      200.033083,
      189,
      ' 8-16-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2.030065,
      NULL,
      NULL,
      0,
      NULL,
      1.241574,
      1.220142,
      55,
      1,
      1,
      24,
      0,
      0,
      64,
      NULL,
      NULL,
      NULL,
      ' 5-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      30,
      108.132856,
      4.171172,
      49.618226,
      NULL,
      20.505961,
      22.725287,
      ' 4-27-2003',
      19,
      13,
      7.530425,
      44.975085,
      19.129641,
      12.353391,
      3,
      '11-20-1981',
      NULL,
      12.268554,
      NULL,
      NULL,
      NULL,
      1.599329,
      NULL,
      21.465800,
      1,
      1.088935,
      17,
      NULL,
      71,
      7.844230,
      1.609656,
      15.923004,
      22.988615,
      NULL,
      NULL,
      0,
      1,
      ' 4-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      97.945296,
      18.518965,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      ' 6-27-2001',
      36,
      ' 5- 8-1991',
      4,
      4,
      ' 8- 6-1997',
      NULL,
      59,
      ' 7-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      ' 6-21-1990',
      53,
      6,
      NULL,
      ' 9-22-1977',
      0,
      12.214346,
      ' 6-16-1982',
      10,
      NULL,
      11,
      14,
      ' 5-12-1997',
      37,
      0,
      19,
      '10-20-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


