set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0114098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '0',
      '3',
      '0',
      NULL,
      NULL,
      '1',
      '4',
      '0',
      NULL,
      '1',
      '3',
      '4',
      '1',
      '2',
      '3',
      NULL,
      NULL,
      '1',
      '1',
      '2',
      '4',
      NULL,
      '',
      '0',
      '',
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      '1',
      '0',
      '4',
      NULL,
      '1',
      NULL,
      '1',
      '0',
      '030',
      '10404030',
      NULL,
      70.782796,
      '3133012',
      0.712517,
      1,
      3,
      0,
      '420222',
      1.084605,
      ' 8-14-1995',
      ' 2- 3-2003',
      29,
      NULL,
      7.668990,
      10.487644,
      17.280312,
      4.245144,
      NULL,
      6,
      9,
      9,
      16,
      11.248423,
      7.753051,
      NULL,
      2,
      8,
      8.717924,
      10,
      24.498189,
      6,
      53,
      9.765450,
      NULL,
      NULL,
      1.432663,
      32.208825,
      165,
      22,
      42,
      22,
      107.528097,
      NULL,
      44,
      2.303848,
      18.834675,
      9,
      124.956931,
      156.846377,
      ' 7-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      18,
      NULL,
      15.674172,
      2,
      6.838144,
      NULL,
      0.999969,
      0,
      186,
      0,
      0,
      54.185094,
      1,
      0.403891,
      16,
      NULL,
      NULL,
      NULL,
      ' 6-27-2000',
      27.232623,
      130,
      NULL,
      41.214274,
      90,
      124,
      78,
      29,
      86,
      81.531527,
      24,
      43,
      ' 3- 6-2003',
      20.398732,
      10,
      14,
      78.791881,
      NULL,
      126.691980,
      7.950275,
      NULL,
      14.641410,
      0.926307,
      ' 5-22-1993',
      NULL,
      11,
      NULL,
      NULL,
      15,
      11,
      0.996762,
      3.381202,
      0,
      34,
      NULL,
      0.168595,
      NULL,
      25.574213,
      NULL,
      10,
      0.117222,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      3,
      '11- 3-1982',
      NULL,
      NULL,
      NULL,
      46,
      ' 0- 5-1995',
      21.674238,
      ' 2-29-1984',
      3,
      3,
      ' 0-13-1998',
      70.924677,
      57.480262,
      '11-28-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      ' 7-15-2003',
      42.176493,
      6.197064,
      33.602179,
      ' 8-10-1999',
      1,
      26.549697,
      NULL,
      4.712158,
      9,
      5,
      30.965175,
      ' 7- 1-1976',
      22,
      1,
      NULL,
      '11-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


