set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678466';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2020',
      '13304113',
      '14040303',
      '32020141',
      NULL,
      '33114320',
      NULL,
      '13340100',
      '24022240',
      NULL,
      '34323432',
      '13413123',
      '33130230',
      '21141224',
      '03034234',
      '21442324',
      '00344031',
      '14444311',
      NULL,
      '01003133',
      '04114242',
      '01123320',
      '00212103',
      NULL,
      '13043231',
      NULL,
      '44000212',
      NULL,
      NULL,
      NULL,
      '44333330',
      '33230144',
      '32101344',
      '22341320',
      '22431010',
      '12030323',
      NULL,
      '11322041',
      '43122030',
      '31213404',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '340',
      '43',
      14.696144,
      14.680452,
      '3041313',
      1.323419,
      1.950437,
      0,
      NULL,
      '143433',
      3,
      NULL,
      NULL,
      55,
      52.931304,
      NULL,
      5.099874,
      2,
      7,
      46,
      10.442196,
      8,
      1.389783,
      17,
      8,
      3.918893,
      3,
      11.400593,
      0,
      7.502191,
      8.375109,
      62,
      7.482397,
      44,
      0,
      36.934263,
      9,
      0.857829,
      10.159742,
      4.769404,
      61,
      105,
      29,
      52.520021,
      ' 0- 8-1992',
      26,
      12,
      14.413550,
      NULL,
      54,
      144,
      ' 6- 1-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.963914,
      NULL,
      39.096172,
      5,
      20.829231,
      4,
      ' 4-19-1993',
      1.462359,
      1.141536,
      37.185218,
      0.081520,
      1,
      16,
      1.440073,
      3,
      28.835505,
      NULL,
      NULL,
      NULL,
      ' 5-28-1991',
      NULL,
      41.449737,
      92.844252,
      57.280258,
      30.989573,
      10,
      86,
      51,
      10.198516,
      67,
      10,
      58,
      ' 8-28-1977',
      9,
      2.608936,
      13.712766,
      51,
      28.574667,
      101.021936,
      NULL,
      ' 5- 6-2002',
      6,
      NULL,
      ' 3- 9-1974',
      0,
      3,
      3.434047,
      NULL,
      6.410669,
      0.418255,
      0,
      16,
      0.392287,
      NULL,
      0.547983,
      1,
      9,
      19.713850,
      0.099758,
      NULL,
      3,
      0,
      ' 7-14-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      131,
      3.565554,
      ' 3-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      ' 2-29-2000',
      NULL,
      5.871770,
      ' 4-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      21.696167,
      ' 1-27-1984',
      31.779989,
      27.301560,
      9.667272,
      ' 1-13-1978',
      0.161285,
      89,
      ' 2-22-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


