set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1334',
      '00023211',
      '01402310',
      '43043321',
      NULL,
      '32040203',
      '34314133',
      NULL,
      '03022002',
      '03113221',
      '13110304',
      NULL,
      '22023420',
      '00131342',
      '21401114',
      '34134330',
      '43343344',
      '23111114',
      '11204214',
      NULL,
      '11023320',
      '44223022',
      NULL,
      NULL,
      NULL,
      '00233140',
      '00024432',
      NULL,
      '01421020',
      NULL,
      NULL,
      '02032102',
      '23310100',
      NULL,
      '01214321',
      '24131303',
      '30322102',
      NULL,
      '11424331',
      NULL,
      '11210013',
      '01223103',
      NULL,
      '42011210',
      '03303141',
      '044',
      NULL,
      NULL,
      12,
      '1122122',
      2,
      NULL,
      2,
      NULL,
      NULL,
      3.946325,
      NULL,
      ' 7-23-1988',
      NULL,
      NULL,
      18,
      18.567665,
      15.430799,
      8,
      NULL,
      14,
      6.500322,
      9,
      4.845756,
      5.049432,
      7.025445,
      NULL,
      4,
      7,
      0.041346,
      6,
      7.928851,
      9,
      34.588873,
      NULL,
      2.784483,
      8,
      1.144470,
      24,
      NULL,
      51,
      110,
      38.606030,
      68.637876,
      ' 0-21-1984',
      21,
      8.194384,
      31.836711,
      NULL,
      22,
      NULL,
      ' 1-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.830807,
      48,
      18,
      1.837450,
      13,
      3.820868,
      NULL,
      1.808794,
      0,
      118,
      NULL,
      0.308428,
      150.179288,
      0.980615,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-1975',
      17,
      18,
      24,
      41.361468,
      6.314640,
      37,
      47.155153,
      57,
      17,
      NULL,
      25,
      36.140444,
      ' 1-25-1996',
      7.213196,
      0.030055,
      4.282752,
      4.823380,
      NULL,
      3.138633,
      2,
      NULL,
      5,
      5.693119,
      ' 2-22-1995',
      1,
      3.469125,
      2,
      6,
      NULL,
      0,
      NULL,
      10.504586,
      0.348003,
      25,
      1.105704,
      NULL,
      14.866167,
      18,
      6.436167,
      1.186154,
      0,
      0,
      '10-10-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.295188,
      ' 7-14-1991',
      NULL,
      ' 5- 9-1988',
      5,
      10.846669,
      ' 2-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      12,
      ' 2- 5-1999',
      40,
      5.986542,
      3.388701,
      ' 7-22-1975',
      NULL,
      277.857343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


