set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '1',
      '3',
      '3',
      '0',
      '4',
      '4',
      '1',
      '3',
      '2',
      '0',
      NULL,
      '1',
      '1',
      NULL,
      '0',
      '0',
      '1',
      '3',
      '0',
      '1',
      '4',
      '0',
      NULL,
      '4',
      '',
      '3',
      '0',
      '3',
      '4',
      '1',
      '',
      NULL,
      '3',
      '0',
      '2',
      '1',
      '2',
      '4',
      NULL,
      NULL,
      '2',
      NULL,
      '2',
      '102',
      '34001303',
      25,
      38,
      '0020233',
      3,
      NULL,
      1,
      NULL,
      '230302',
      3,
      ' 4-16-1980',
      ' 1-12-1986',
      NULL,
      181,
      42,
      16,
      3.752302,
      5.809830,
      36.998990,
      8.990767,
      0,
      0.080278,
      13,
      12.803784,
      51,
      NULL,
      NULL,
      1,
      NULL,
      9.588201,
      NULL,
      4,
      33.031454,
      9.082770,
      55.398956,
      6.628776,
      0,
      22.734278,
      NULL,
      88.715376,
      159,
      82.727965,
      62.404453,
      '11-12-1997',
      14.850169,
      74,
      13.497929,
      6,
      155,
      213,
      ' 3-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      1.997520,
      2,
      4.564916,
      3,
      NULL,
      ' 1-28-1977',
      2.662727,
      NULL,
      90,
      0.705279,
      NULL,
      NULL,
      1,
      2.185111,
      24,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1980',
      52,
      77,
      29,
      61,
      41,
      NULL,
      48,
      46.429248,
      NULL,
      20,
      3,
      8,
      ' 7-12-2003',
      NULL,
      24.649094,
      3,
      NULL,
      NULL,
      6.227528,
      3,
      ' 1- 4-1986',
      23,
      NULL,
      NULL,
      3.985561,
      15,
      16,
      14,
      23,
      2,
      1,
      11.524431,
      0,
      101,
      1,
      1.596497,
      NULL,
      31,
      1,
      NULL,
      0.765526,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102.348373,
      0.261113,
      ' 2-29-1986',
      NULL,
      NULL,
      NULL,
      27.611441,
      ' 8-11-2000',
      NULL,
      NULL,
      10,
      3.859036,
      '11-15-2001',
      111,
      115,
      ' 2-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      7,
      ' 4-27-2002',
      35,
      19.572738,
      20.574407,
      ' 3- 4-1996',
      NULL,
      83.236423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


