set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8809971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3443',
      NULL,
      '23401111',
      '40340422',
      '23122010',
      '32144124',
      '14421032',
      '20432422',
      '13411121',
      '22434004',
      '04043343',
      NULL,
      '32032420',
      '21004413',
      '13121010',
      '43340414',
      '23023211',
      '33143011',
      '11402221',
      '13140230',
      '34010423',
      '00424303',
      NULL,
      '40331330',
      '31242003',
      '03202444',
      '30344233',
      '21231101',
      '02330204',
      NULL,
      '12341211',
      '44022244',
      NULL,
      '33444420',
      '01402443',
      '33001343',
      NULL,
      '14340342',
      '42333414',
      NULL,
      '20442202',
      '12324222',
      '43330131',
      '43422230',
      '10213313',
      '404',
      '42',
      28.938568,
      5.935976,
      '1132034',
      0,
      1.051589,
      3,
      NULL,
      '321304',
      1.893234,
      ' 9-11-1986',
      NULL,
      53,
      NULL,
      54,
      4.300148,
      36.322426,
      NULL,
      12,
      NULL,
      15.626247,
      2.046724,
      29.456533,
      14.336858,
      29.259132,
      11,
      NULL,
      18.421573,
      NULL,
      NULL,
      26,
      12,
      35.560342,
      13,
      67.824660,
      28.664227,
      0,
      3.272084,
      NULL,
      61,
      NULL,
      195.264025,
      126,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      35.594738,
      78,
      ' 9-15-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      4.814603,
      2,
      3,
      8,
      7,
      '11-25-1993',
      1,
      1,
      2,
      1,
      1.811541,
      116.432947,
      2.633120,
      1,
      96,
      NULL,
      NULL,
      NULL,
      NULL,
      7.928169,
      62,
      NULL,
      69,
      105,
      75.875238,
      10,
      54,
      74.936656,
      65,
      79,
      15,
      ' 4- 8-1994',
      33.888811,
      NULL,
      37,
      58,
      108.746826,
      52.888845,
      NULL,
      ' 6- 7-1989',
      13,
      27,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      13,
      NULL,
      13,
      0.639146,
      10.843884,
      1.261097,
      NULL,
      19.958697,
      0,
      0,
      0.355678,
      1,
      0.778153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      11.925002,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      ' 3- 5-1978',
      32,
      NULL,
      NULL,
      12.007924,
      ' 2- 4-2002',
      90.543404,
      NULL,
      ' 6-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      23,
      NULL,
      24.769962,
      66,
      25.901270,
      ' 3-19-1990',
      0.558181,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


