set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526540';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '2',
      '2',
      '0',
      NULL,
      '1',
      '4',
      '2',
      '2',
      NULL,
      '0',
      '1',
      '2',
      '1',
      NULL,
      '2',
      '3',
      '0',
      '1',
      '2',
      '1',
      '0',
      '4',
      NULL,
      '2',
      '',
      '2',
      '1',
      '4',
      '0',
      '2',
      '',
      '',
      '1',
      NULL,
      '0',
      NULL,
      '2',
      '2',
      '2',
      '3',
      '1',
      NULL,
      '0',
      '014',
      '32324012',
      NULL,
      4.950048,
      '2320040',
      NULL,
      1.075180,
      NULL,
      NULL,
      '400134',
      1,
      '10-20-1977',
      ' 5-20-1988',
      NULL,
      57.714638,
      41,
      7.518427,
      43.360141,
      0,
      116,
      10,
      24.881518,
      27.093265,
      27,
      19.227980,
      39.906839,
      NULL,
      22,
      NULL,
      2.829651,
      NULL,
      43,
      1,
      19,
      28.758225,
      93.029604,
      15,
      NULL,
      NULL,
      63,
      52.125993,
      NULL,
      NULL,
      NULL,
      ' 3-15-1989',
      28.777414,
      33,
      3.342220,
      32.475113,
      NULL,
      115.493640,
      ' 4-29-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      4,
      11.228969,
      8.132924,
      NULL,
      ' 4- 4-2000',
      0.410539,
      1.207651,
      242.403387,
      0,
      0.230262,
      146,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-1980',
      65.443431,
      44.362224,
      122,
      91.952324,
      80.651746,
      64,
      NULL,
      38.549542,
      29,
      69.900651,
      89.123580,
      NULL,
      ' 9-15-1984',
      28.912229,
      24,
      25,
      65,
      55.000445,
      134.612408,
      6,
      ' 9-14-1994',
      NULL,
      NULL,
      ' 2-10-1976',
      11.783011,
      22,
      25,
      4.954449,
      NULL,
      17,
      NULL,
      12.858913,
      0.128418,
      66.932418,
      2,
      2.415858,
      1.290310,
      27.203921,
      0,
      3,
      1.880882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      2,
      ' 2- 0-1990',
      NULL,
      NULL,
      NULL,
      43,
      ' 4- 5-1982',
      17,
      ' 7-15-1989',
      17,
      NULL,
      ' 0-21-1979',
      NULL,
      90.271535,
      ' 5-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 9-15-1974',
      NULL,
      18,
      28.891869,
      ' 6-13-2002',
      1.371552,
      25,
      ' 5-12-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


