set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1023',
      '14440024',
      '43202143',
      '24233122',
      '34143203',
      '14020443',
      '32123031',
      '21224244',
      NULL,
      NULL,
      '20212124',
      NULL,
      '40014143',
      '34410412',
      '30404141',
      NULL,
      '24242023',
      NULL,
      '04103323',
      '31400230',
      '43000203',
      '14103301',
      '03340130',
      '21401020',
      '13333224',
      '41220140',
      '33132130',
      NULL,
      NULL,
      '01400430',
      '40100312',
      NULL,
      NULL,
      '31024033',
      NULL,
      '43433031',
      '31100333',
      '31041334',
      '02310113',
      '04000013',
      NULL,
      '13041033',
      NULL,
      '42112100',
      '14144144',
      NULL,
      NULL,
      NULL,
      NULL,
      '0433402',
      1.745613,
      NULL,
      0,
      NULL,
      '441304',
      0,
      ' 3- 2-1991',
      NULL,
      68,
      NULL,
      9.247474,
      10.454140,
      NULL,
      3.761647,
      0,
      NULL,
      10.397381,
      12.560973,
      23,
      4.824059,
      0.734778,
      8,
      NULL,
      9,
      4.228904,
      11.736806,
      14.908436,
      2,
      42,
      2,
      15,
      4.487056,
      NULL,
      55.716568,
      87,
      32.312556,
      6,
      NULL,
      11.467103,
      ' 5-27-1994',
      NULL,
      39.040901,
      13.572809,
      2,
      40.875767,
      77.148651,
      '11- 0-1985',
      3,
      0,
      NULL,
      36.449612,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.512610,
      1,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-12-1987',
      13.534031,
      NULL,
      12.860265,
      100,
      74,
      92,
      3.422764,
      70.307282,
      5,
      40,
      41.587736,
      NULL,
      ' 4-22-2001',
      1,
      8.863204,
      6,
      6.003900,
      NULL,
      3.874477,
      1.187927,
      ' 8- 5-1996',
      11,
      NULL,
      '10- 2-1986',
      4,
      2.145261,
      3,
      15.857882,
      8.039888,
      7.267244,
      NULL,
      5.416174,
      NULL,
      NULL,
      1.969708,
      8,
      1.486855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-27-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      3.156844,
      1.725773,
      ' 7-22-1977',
      0,
      73.943834,
      NULL,
      2.378380,
      42.679007,
      14,
      82,
      '11-19-1986',
      NULL,
      1.693329,
      NULL,
      '10- 9-2003',
      NULL,
      NULL,
      NULL,
      58,
      91.441575,
      NULL,
      NULL,
      NULL,
      145.566860,
      36,
      69,
      0,
      36,
      NULL,
      31,
      1.280279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353728,
      1.285891,
      NULL,
      3.826805,
      8.563613,
      396.381884,
      13,
      19.258773,
      NULL,
      0,
      27.794857,
      1,
      NULL,
      1.137458,
      0.378612,
      NULL,
      0.838679,
      NULL,
      18,
      61,
      0.961572,
      12.304582,
      38,
      0,
      0.772660,
      26,
      NULL,
      NULL,
      12.917820,
      9,
      29.442769,
      41,
      0.826187,
      48.484259,
      1.733546,
      0.060871,
      33.891111,
      9.805953,
      NULL,
      6,
      38.007607,
      25,
      1.875069,
      NULL,
      0,
      14.762448,
      1.939003,
      8,
      NULL,
      1,
      1.598318,
      0,
      43.887292,
      ' 0-14-1985',
      ' 2-25-1999',
      '10-21-1989',
      NULL,
      '11-28-1974',
      NULL,
      ' 7-15-1989',
      NULL);
commit;
end;
/


