set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9111838';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0404',
      '23321313',
      '30103042',
      '10040112',
      '40221023',
      '10423243',
      '20144033',
      NULL,
      '44310033',
      '30032020',
      '10111244',
      '23000040',
      NULL,
      '33342424',
      '34021202',
      '20243024',
      '13433222',
      '40110032',
      NULL,
      '43401213',
      '20111421',
      '00311110',
      '12440203',
      '13340034',
      '22130414',
      NULL,
      NULL,
      '41202001',
      '00014143',
      '32012333',
      NULL,
      '24111021',
      NULL,
      '40013413',
      '23041103',
      '22342424',
      '10003301',
      '13140100',
      '01131231',
      NULL,
      '32224021',
      NULL,
      '01141430',
      NULL,
      '43344340',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      ' 7-12-1990',
      25,
      NULL,
      17.287322,
      16.084877,
      0.684479,
      7,
      59.048999,
      7,
      NULL,
      5,
      15,
      18,
      21,
      NULL,
      1.895489,
      NULL,
      3.156398,
      1,
      24,
      1.120649,
      24,
      NULL,
      10,
      2,
      NULL,
      NULL,
      8,
      46,
      3.594335,
      30.123983,
      NULL,
      ' 2- 8-1977',
      23.212771,
      14,
      4.907555,
      9,
      81,
      155.580798,
      '11-18-1997',
      NULL,
      1.301414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.948988,
      NULL,
      NULL,
      0.070355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1994',
      122.631930,
      72,
      26.781367,
      NULL,
      28.312879,
      43.713054,
      70.201430,
      NULL,
      116.988534,
      NULL,
      6.303810,
      18,
      ' 4-21-2003',
      4,
      1,
      13.930327,
      22,
      45,
      10.218321,
      0,
      '11-14-2000',
      2.919905,
      NULL,
      ' 7-16-1978',
      1,
      NULL,
      NULL,
      17,
      5.636281,
      1.281660,
      NULL,
      4,
      NULL,
      2.901905,
      0.978779,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      11,
      ' 4- 0-1981',
      NULL,
      NULL,
      ' 0-11-1981',
      5,
      52,
      12,
      43,
      ' 4-17-1990',
      40,
      NULL,
      359.680258,
      ' 1- 1-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      75.241088,
      7.972133,
      NULL,
      NULL,
      61.228643,
      57,
      11.119779,
      3,
      23.549522,
      NULL,
      NULL,
      NULL,
      NULL,
      75.915376,
      1,
      1,
      82,
      3.734097,
      0,
      33.886753,
      NULL,
      NULL,
      272,
      NULL,
      2,
      NULL,
      1.888887,
      NULL,
      NULL,
      0.070112,
      NULL,
      0,
      1.670090,
      1.038279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      47.713166,
      1.183444,
      2,
      NULL,
      15,
      0.848362,
      NULL,
      1,
      NULL,
      0.797713,
      0.486146,
      NULL,
      2,
      0.800661,
      13.679688,
      NULL,
      NULL,
      8.532321,
      NULL,
      3.077071,
      0.278309,
      2.313677,
      NULL,
      5.765573,
      NULL,
      1,
      2.181923,
      NULL,
      ' 2-21-1987',
      ' 8-13-1986',
      ' 4-13-1998',
      '11-18-1986',
      NULL,
      ' 3- 6-1989',
      ' 7-14-2003',
      NULL);
commit;
end;
/


