set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204599';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0004',
      NULL,
      '34123244',
      '30434342',
      '41134433',
      NULL,
      '12244101',
      '24343213',
      '30003320',
      NULL,
      '13122430',
      '44430143',
      '11422014',
      '44321222',
      NULL,
      '30102334',
      '24242011',
      '20041410',
      '14410411',
      NULL,
      NULL,
      NULL,
      '30322401',
      '01001342',
      NULL,
      '22212342',
      '24124222',
      '32104204',
      '04130424',
      NULL,
      '33400440',
      '41304000',
      '12032102',
      '14313142',
      NULL,
      NULL,
      '43334232',
      '01420202',
      '24303101',
      '11033111',
      '22434104',
      NULL,
      '14021241',
      '24140141',
      '00230202',
      NULL,
      '43',
      28,
      3.102969,
      '0034302',
      3,
      0,
      1,
      NULL,
      '102223',
      3,
      NULL,
      ' 3-29-2001',
      70.684850,
      NULL,
      20,
      17,
      15.880488,
      9,
      95,
      9,
      NULL,
      25,
      34,
      0,
      NULL,
      19.457627,
      27,
      3,
      12.048780,
      10,
      0,
      NULL,
      14.787220,
      12.685391,
      96.473644,
      9.466222,
      NULL,
      121.653080,
      219,
      28,
      89,
      NULL,
      NULL,
      ' 1- 1-1994',
      6,
      39.771847,
      16,
      NULL,
      52.097830,
      224.985748,
      ' 3- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.680523,
      NULL,
      4,
      0.153919,
      NULL,
      3,
      '11-16-1981',
      0.130444,
      1.615477,
      209,
      NULL,
      1,
      149.625992,
      3.103206,
      1,
      19.945735,
      NULL,
      NULL,
      NULL,
      ' 4-27-1986',
      83.554668,
      112.725898,
      84,
      66,
      94.266779,
      50,
      1,
      NULL,
      55.419910,
      9,
      35.555489,
      NULL,
      '11-21-1989',
      5,
      8.991598,
      13.169913,
      11.490004,
      89.749836,
      NULL,
      10.544525,
      ' 2- 1-1994',
      0,
      7,
      ' 0-25-1985',
      13,
      23,
      30,
      0.949875,
      12,
      1,
      1.171251,
      3,
      1,
      39,
      2,
      10.403738,
      3.393987,
      24.106679,
      0.854741,
      NULL,
      1.325998,
      1,
      ' 2- 6-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      0.519228,
      ' 6- 9-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1980',
      34,
      '10- 1-1989',
      20.700925,
      4,
      '10-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 7-19-2002',
      45.977552,
      0.019670,
      23,
      '10-26-1982',
      NULL,
      22.212951,
      '11-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


