set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '1',
      '1',
      '3',
      '3',
      '4',
      '1',
      NULL,
      '1',
      NULL,
      '1',
      '1',
      '4',
      '2',
      '4',
      '0',
      '0',
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      '3',
      '',
      '2',
      '',
      NULL,
      NULL,
      '1',
      NULL,
      '3',
      '',
      '',
      '1',
      '1',
      NULL,
      '4',
      '3',
      '2',
      '4',
      '3',
      '3',
      '3',
      '4',
      '134',
      '04230010',
      3,
      35.103263,
      '2402410',
      0.494182,
      45.183186,
      1,
      NULL,
      '330313',
      3.018153,
      ' 2-10-2002',
      NULL,
      63.936714,
      51.528921,
      2.168697,
      1.594239,
      8,
      15,
      13,
      NULL,
      NULL,
      5.993238,
      NULL,
      10,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      8.833393,
      11.380521,
      21.729789,
      20,
      14,
      69,
      NULL,
      1,
      27,
      115,
      NULL,
      144,
      92.579477,
      129,
      '10-28-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.935389,
      NULL,
      15.297443,
      11,
      1.527560,
      0,
      ' 5- 0-1976',
      0,
      1.618149,
      NULL,
      4,
      1,
      23,
      0,
      1,
      12.969557,
      NULL,
      NULL,
      NULL,
      '10- 9-1995',
      74,
      75.854322,
      11,
      62,
      NULL,
      80,
      50.180718,
      43,
      73.306618,
      81,
      82,
      37.124830,
      ' 5- 5-1979',
      8.432527,
      16,
      8.101379,
      NULL,
      10,
      8.840603,
      1.170638,
      '11-13-2002',
      4.636315,
      4.103233,
      ' 8-20-1993',
      NULL,
      18.621719,
      8,
      0,
      23,
      3.315139,
      NULL,
      15.754716,
      1,
      115.112972,
      3.758421,
      5.041081,
      NULL,
      18,
      1,
      1.264208,
      0.941004,
      0.606688,
      ' 3-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      104.075755,
      8,
      ' 2-10-1991',
      NULL,
      NULL,
      NULL,
      26.926961,
      ' 4-21-1974',
      8,
      ' 4-17-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      8,
      NULL,
      25,
      3.070584,
      25,
      '10- 6-1981',
      1.298592,
      24.379922,
      ' 0-27-1992',
      8.786372,
      7,
      3,
      77.370911,
      NULL,
      22,
      1.404943,
      NULL,
      ' 5-14-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


