set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9407664';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '0',
      NULL,
      '0',
      '0',
      '4',
      '1',
      NULL,
      NULL,
      '0',
      '4',
      '4',
      '1',
      '2',
      NULL,
      '1',
      '0',
      '2',
      '0',
      '0',
      '',
      NULL,
      '',
      '3',
      '4',
      NULL,
      '1',
      '2',
      '',
      '',
      '4',
      '4',
      '0',
      '3',
      '4',
      '2',
      '2',
      '1',
      '0',
      '1',
      NULL,
      '323',
      '20043302',
      NULL,
      NULL,
      '2132210',
      0,
      33,
      3,
      NULL,
      '300422',
      2.872030,
      '11- 1-1988',
      ' 8-20-1991',
      26,
      42.129066,
      0,
      9.987995,
      14,
      10,
      34,
      10,
      2.796710,
      NULL,
      4,
      5,
      5.314779,
      2,
      NULL,
      0,
      8,
      3,
      53.851869,
      3.126781,
      40,
      5,
      7,
      1.189373,
      1,
      NULL,
      57,
      6.363715,
      NULL,
      34.736310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      6,
      13.786603,
      6.792345,
      0,
      ' 5-24-1977',
      1.805506,
      NULL,
      115.750188,
      1.835670,
      1,
      30.772750,
      0.966848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1991',
      56.221496,
      NULL,
      NULL,
      37,
      65.388271,
      80,
      97,
      4.689877,
      12.298360,
      47,
      100.149811,
      53,
      ' 2- 2-1991',
      NULL,
      1,
      9,
      20.940109,
      22.234178,
      3,
      4,
      '10- 1-1979',
      5,
      1.736200,
      ' 2-23-1979',
      7,
      5,
      5.925170,
      0,
      NULL,
      0,
      0.992090,
      4,
      1.778307,
      6.427985,
      0,
      NULL,
      12.481553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-11-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      178.225144,
      18.300788,
      ' 1-24-1994',
      NULL,
      NULL,
      NULL,
      39,
      ' 7-14-1988',
      31.272849,
      NULL,
      NULL,
      NULL,
      NULL,
      36.759418,
      NULL,
      ' 1-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 7-13-1985',
      NULL,
      NULL,
      13.987156,
      NULL,
      NULL,
      23.803258,
      ' 7-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      0,
      143.551575,
      ' 3- 3-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


